﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using VI = BMS.VistaIntegration.FacadeContracts;
using BMS.Utils;
using BMS.Web.App_GlobalResource;
using BMS.Web.Views;

namespace BMS.Web.Controllers
{
    public class BackgroundProcessorsController : BaseController
    {
        [ReadPermissionAuthFilter]
        public ActionResult Index()
        {
            BackgroundProcessorsViewModel model = new BackgroundProcessorsViewModel();
            FillBackgroundProcessorsViewModel(model);
            return View(model);
        }

        [HttpPost]
        [UpdatePermissionAuthFilter]
        public ActionResult Index([Bind(Exclude = "RememberMe")] BackgroundProcessorsViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                input.LoggedUser = loggedUser;
                if (!string.IsNullOrEmpty(input.ButtonSaveWhiteboardScheduler))
                {
                    if (!string.IsNullOrEmpty(input.SelectedWhiteboardSchedulerId) && input.SelectedWhiteboardSchedulerId != Strings.SelectAScheduler)
                    {
                        string oldSchedulerId = input.CurrentWhiteboardScheduler == null ? string.Empty : input.CurrentWhiteboardScheduler.Id;
                        string newSchedulerId = string.Empty;
                        if (input.SelectedWhiteboardSchedulerId != Strings.DeleteScheduler)
                            newSchedulerId = input.SelectedWhiteboardSchedulerId;
                        FacadeManager.ConfigurationInterface.SaveFacilityWhiteboardReportScheduler(this.loggedUser.Domain, newSchedulerId, oldSchedulerId, this.loggedUser.Facility.Id);
                        if (input.SelectedWhiteboardSchedulerId == Strings.DeleteScheduler)
                            return View("DeleteConfirmation", input);
                        else
                            return View("AddEditConfirmation", input);
                    }
                    else
                    {
                        ViewData[InputHelpers.FormNameKey] = Strings.WhiteboardReport;
                        ModelState.AddModelError(string.Empty, Strings.YouMustSelectAScheduler);
                    }
                }

                if (!string.IsNullOrEmpty(input.ButtonSaveWaitingListScheduler))
                {
                    VI.VistASite vistaSite = GetVistaSite(this.loggedUser.Facility.VistaSite.Id.extension);
                    VI.Admin.VistaDataType dataType = VI.Admin.VistaDataType.PatientsPendingBedPlacementList;

                    if (!string.IsNullOrEmpty(input.SelectedWaitingListMethodId) && input.SelectedWaitingListMethodId != Strings.SelectAMethod && input.SelectedWaitingListSchedulerId != Strings.DeleteScheduler)
                    {
                        //save
                        VI.Admin.DataRetrieval dataRetrieval = null;
                        if (vistaSite.DataRetrievalDetails.ContainsKey(dataType))
                            dataRetrieval = vistaSite.DataRetrievalDetails[dataType];
                        else
                        {
                            dataRetrieval = new VI.Admin.DataRetrieval();
                            vistaSite.DataRetrievalDetails.Add(dataType, dataRetrieval);
                        }
                        dataRetrieval.DataRetrievalMethod = (DataRetrievalMethod)Enum.Parse(typeof(DataRetrievalMethod), input.SelectedWaitingListMethodId);
                        //the scheduler is saved only if the retrieval method is calendar based.
                        if (input.HL7Checked)
                            dataRetrieval.JobCalendar = null;
                        else
                        {
                            if (!string.IsNullOrEmpty(input.SelectedWaitingListSchedulerId) && input.SelectedWaitingListSchedulerId != Strings.SelectAScheduler)
                            {
                                dataRetrieval.JobCalendar = GetScheduler(input.SelectedWaitingListSchedulerId);
                            }
                            else
                            {
                                ViewData[InputHelpers.FormNameKey] = Strings.WaitingList;
                                ModelState.AddModelError(string.Empty, Strings.YouMustSelectAScheduler);
                            }
                        }
                        if (ModelState.IsValid)
                        {
                            FacadeManager.ConfigurationInterface.SaveVistASite(vistaSite, loggedUser.Domain);
                            return View("AddEditConfirmation", input);
                        }
                    }
                    else
                    {
                        if (input.SelectedWaitingListSchedulerId == Strings.DeleteScheduler)
                        {
                            FacadeManager.ConfigurationInterface.DeleteVistaASite(this.loggedUser.Domain, this.loggedUser.Facility.VistaSite.Id.extension);
                            return View("DeleteConfirmation", input);
                        }
                        ViewData[InputHelpers.FormNameKey] = Strings.WaitingList;
                        ModelState.AddModelError(string.Empty, Strings.YouMustSelectAMethod);
                    }

                }
                FillBackgroundProcessorsViewModel(input);
                return View(input);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void FillBackgroundProcessorsViewModel(BackgroundProcessorsViewModel model)
        {
            model.CurrentWhiteboardScheduler = FacadeManager.ConfigurationInterface.GetFacilityWhiteboardReportScheduler(this.loggedUser.Domain, this.loggedUser.Facility.Id);
            List<VI.Admin.JobCalendar> schedulers = FacadeManager.ConfigurationInterface.GetDefinedCalendars(this.loggedUser.Domain).OrderBy(jobCal => jobCal.Name).ToList();
            if (model.CurrentWhiteboardScheduler != null)
            {
                model.WhiteboardReportSchedulers = schedulers.Where(s => s.Id != model.CurrentWhiteboardScheduler.Id).ToList();
                model.WhiteboardReportSchedulers.Add(new VI.Admin.JobCalendar() { Id = Strings.DeleteScheduler, Name = Strings.DeleteScheduler });
            }
            else
                model.WhiteboardReportSchedulers = schedulers;
            if (!model.WhiteboardReportSchedulers.Any(jobCal => jobCal.Id.Equals(Strings.SelectAScheduler, StringComparison.InvariantCultureIgnoreCase )))
                model.WhiteboardReportSchedulers.Insert(0, new VI.Admin.JobCalendar() { Id = Strings.SelectAScheduler, Name = Strings.SelectAScheduler });

            model.RetrievalMethods = new List<DataRetrievalMethod>((DataRetrievalMethod[])Enum.GetValues(typeof(DataRetrievalMethod))).Select(drm => new SelectableEnum<DataRetrievalMethod>(drm, false)).ToList();

            model.WaitingListSchedulers = schedulers;
            if (!model.WaitingListSchedulers.Any(jobCal => jobCal.Id.Equals(Strings.SelectAScheduler, StringComparison.InvariantCultureIgnoreCase)))
                model.WaitingListSchedulers.Insert(0, new VI.Admin.JobCalendar { Id = Strings.SelectAScheduler, Name = Strings.SelectAScheduler });
            VI.VistASite vistaSite = GetVistaSite(this.loggedUser.Facility.VistaSite.Id.extension);
            //load the settings for the selected dataType in the model
            if (vistaSite.DataRetrievalDetails != null &&
                vistaSite.DataRetrievalDetails.ContainsKey(VI.Admin.VistaDataType.PatientsPendingBedPlacementList) &&
                vistaSite.DataRetrievalDetails[VI.Admin.VistaDataType.PatientsPendingBedPlacementList].DataRetrievalMethod != (DataRetrievalMethod)0)
            {
                string selectedWaitingListMethodId = vistaSite.DataRetrievalDetails[VI.Admin.VistaDataType.PatientsPendingBedPlacementList].DataRetrievalMethod.ToString("G");
                if (!string.IsNullOrEmpty(selectedWaitingListMethodId))
                {
                    model.CurrentWaitingListScheduler = Strings.AuditTableColumnMethod + ": " + model.RetrievalMethods.Where(a => a.EntityName == selectedWaitingListMethodId).Select(a => a.DisplayName).FirstOrDefault();
                    model.WaitingListSchedulers.Add(new VI.Admin.JobCalendar() { Id = Strings.DeleteScheduler, Name = Strings.DeleteScheduler });
                }
                model.HL7Checked = vistaSite.DataRetrievalDetails[VI.Admin.VistaDataType.PatientsPendingBedPlacementList].IsHL7Enabled;
                if (!model.HL7Checked &&
                     vistaSite.DataRetrievalDetails[VI.Admin.VistaDataType.PatientsPendingBedPlacementList].JobCalendar != null &&
                     vistaSite.DataRetrievalDetails[VI.Admin.VistaDataType.PatientsPendingBedPlacementList].JobCalendar.Id != null)
                {
                    model.CurrentWaitingListScheduler = model.CurrentWaitingListScheduler + " - " + Strings.Scheduler + ": " + model.WaitingListSchedulers.Where(a => a.Id == vistaSite.DataRetrievalDetails[VI.Admin.VistaDataType.PatientsPendingBedPlacementList].JobCalendar.Id).Select(a => a.Name).FirstOrDefault();
                }
            }
            else
            {
                model.CurrentWaitingListScheduler = string.Empty;
            }
            model.LoggedUser = loggedUser;
        }
    }
}