﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Facade.Data;
using BMS.Facade;
using BMS.Utils;
using BMS.Facade.Fault;
using BMS.Web.App_GlobalResource;

namespace BMS.Web.Controllers
{
    public class AuditLogReportController : BaseController
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<IReportInfo> listReports = FacadeManager.ReportsInterface.GetOtherReports();
                IReportInfo report = null;

                if (listReports.Count > 0)
                    report = listReports.Where(rpt => rpt.Name == Constants.ICON_FLAG_RPT).FirstOrDefault();

                //Redirect to the report
                if (report == null)
                    throw new ReportRenderException(Constants.ICON_FLAG_RPT, Strings.ERR_ReportNotAvailable);
                else
                {
                    if (report.Parameters == null)
                        report.Parameters = new Dictionary<string, string>();
                    
                    report.Parameters.Add(Constants.REPORT_TITLE, Strings.IconFlagReportTitle);
                    report.Parameters.Add(Constants.REP_TIME_ZONE_MINUTES_OFFSET, RepTimeZoneMinutesOffset);
                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, QueryStrings["returnUrl"]);

                    if (!String.IsNullOrEmpty(p) && QueryStrings.Count > 1)
                    {
                        report.Parameters.Add(Constants.REP_VISN_NETWORK_VISN_EXTENSION, QueryStrings["visn"]);
                        report.Parameters.Add(Constants.REP_REGION_EXTENSIONS, QueryStrings["region"]);
                        report.Parameters.Add(Constants.REP_VISN_EXTENSIONS, QueryStrings["visn"]);

                        //from site options
                        if (!String.IsNullOrEmpty(QueryStrings["facility"]))
                        {
                            report.Parameters.Add(Constants.REP_GENERAL_FACILITY_EXTENSION_TO_UPPER, QueryStrings["facility"]);
                            //report.Parameters.Add(Constants.REP_FACILITIES_IDS, QueryStrings["facility"]);
                            report.Parameters.Add(Constants.REP_SELECT_REPORT, Strings.SelectReportParamValueFac);
                            report.Parameters.Add(Constants.REP_IS_FACILITY, "1");
                            report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, Strings.ReturnToAdminMainPage);
                        }
                        else //from visn page
                        {
                            report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, Strings.ReturnToBedBoardHomePage);
                            report.Parameters.Add(Constants.REP_SELECT_REPORT, Strings.SelectReportParamValueFac);
                            report.Parameters.Add(Constants.REP_IS_FACILITY, "1");
                        }
                    }
                    else //from admin menu
                    {
                        report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, Strings.ReturnToAdminMenu);
                        report.Parameters.Add(Constants.REP_SELECT_REPORT, Strings.SelectReportParamValueNat);
                    }

                    return Redirect(report.Url);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
