﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using Microsoft.Web.Mvc;
using BMS.Utils;
using BMS.Web.Controllers.Shared;
using System.Text;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class ApplicationParametersController : BaseController
    {
        /// <summary>
        /// Default action for the MaintainMarquee controller.
        /// </summary>
        /// <returns>Index view result.</returns>
        [ReadPermissionAuthFilterAttribute(OperationOverride="Admin, Index")]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ApplicationParametersModel model = new ApplicationParametersModel();
                ApplicationParameters parameters = FacadeManager.ConfigurationInterface.GetApplicationParameters(this.loggedUser.Domain);

                if (parameters != null)
                {
                    model.ClinicalInventoryLink = parameters.GetValue(Constants.APPLICATION_PARAMETERS_CLINICAL_INVENTORY);
                    model.NationalPatientPlacementAlertEmail = parameters.GetValue(Constants.APPLICATION_PARAMETERS_NPP_ALERT_EMAIL);
                }
                model.LoggedUser = loggedUser;

                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute(OperationOverride = "Admin, Index")]
        public ActionResult Index([Bind(Exclude = "RememberMe")] ApplicationParametersModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return this.RedirectToAction<ApplicationParametersController>(act => act.Index());
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Changes the marquee text.
        /// </summary>
        /// <param name="model">Model.</param>
        /// <returns></returns>
        [HttpPost]
        [UpdatePermissionAuthFilterAttribute(OperationOverride = "AdminIcon, Index")]
        public ActionResult ChangeApplicationParameters([Bind(Exclude = "RememberMe")] ApplicationParametersModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ApplicationParameters settings = model.ToApplicationParameters();
                FacadeManager.ConfigurationInterface.SaveApplicationParameters(this.loggedUser.Domain, settings);

                model.ClinicalInventoryLink = settings.GetValue(Constants.APPLICATION_PARAMETERS_CLINICAL_INVENTORY);
                model.NationalPatientPlacementAlertEmail = settings.GetValue(Constants.APPLICATION_PARAMETERS_NPP_ALERT_EMAIL);
                model.LoggedUser = loggedUser;

                return View("Saved", model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
