﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Facade;
using BMS.Utils;
using BMS.Facade.Data;
using BMS.VistaIntegration.FacadeContracts.Admin;
using BMS.Web.App_GlobalResource;
using BMS.Web.Controllers.Shared;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class AdminWhiteboardReportController : BaseController
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.WhiteboardReportSelectedBackgroundColor = Strings.AnchorBackgroundColor;

                AdminWhiteboardReportViewModel model = new AdminWhiteboardReportViewModel();
                model.Entries = FacadeManager.ConfigurationInterface.GetWhiteboardReportEntries(this.loggedUser.Domain).OrderBy(wrce => wrce.Calendar.Name).ToList<WhiteboardReportConfigEntry>();
                model.Calendars = FacadeManager.ConfigurationInterface.GetDefinedCalendars(this.loggedUser.Domain)
                                                                      .Where(s => !model.Entries.Exists(ss => ss.Calendar.Id == s.Id))
                                                                      .OrderBy(jobCal => jobCal.Name)
                                                                      .ToList();
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index(AdminWhiteboardReportViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.WhiteboardReportSelectedBackgroundColor = Strings.AnchorBackgroundColor;

                WhiteboardReportConfigEntry newEntry = new WhiteboardReportConfigEntry();
                newEntry.Calendar = FacadeManager.ConfigurationInterface.GetDefinedCalendars(loggedUser.Domain).Where(a => a.Id == input.SelectedCalendarId).Single();
                newEntry.Facilities = new List<Facility>();
                input.Entry = newEntry;
                input.Facilities = FacadeManager.EntityInterface.GetFacilities()
                                .Select(f => new Facility { Id = f.Id, Name = ((f.Address1 != null) ? (!string.IsNullOrEmpty(f.Address1.city) ? f.Address1.city : string.Empty) : string.Empty) + " (" + f.SiteNumber + ", " + f.Code + ")" })
                                .Select(a => new CheckItem<Facility>() { Item = a }).OrderBy(a => a.Item.Name).ToList();
                input.LoggedUser = loggedUser;
                return View("Edit", input);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Edit Whiteboard
        /// </summary>
        /// <param name="ien">The ien.</param>
        /// <returns></returns>
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.WhiteboardReportSelectedBackgroundColor = Strings.AnchorBackgroundColor;
                string schedulerId = null;
                if (p == null || string.IsNullOrEmpty(p))
                    schedulerId = TempData.Get<string>("schedulerId");
                else
                    schedulerId = QueryStrings["calendarId"];

                AdminWhiteboardReportViewModel model = new AdminWhiteboardReportViewModel();
                WhiteboardReportConfigEntry entry = FacadeManager.ConfigurationInterface.GetWhiteboardReportEntries(loggedUser.Domain).Where(s => s.Calendar.Id == schedulerId).Single();
                model.Entry = entry;
                model.Facilities = FacadeManager.EntityInterface.GetFacilities()
                                .Select(f => new Facility { Id = f.Id, Name = ((f.Address1 != null) ? (!string.IsNullOrEmpty(f.Address1.city) ? f.Address1.city : string.Empty) : string.Empty) + " (" + f.SiteNumber + ", " + f.Code + ")" })
                                .Select(a => new CheckItem<Facility>() { Item = a }).OrderBy(a => a.Item.Name).ToList();
                model.Facilities.Where(a => entry.Facilities.Exists(b => b.Id.extension.Equals(a.Item.Id.extension, StringComparison.InvariantCultureIgnoreCase))).ForEach(s => s.IsChecked = true);
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Edit(AdminWhiteboardReportViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                WhiteboardReportConfigEntry entry = model.Entry;
                entry.Facilities = new List<Facility>();
                model.Facilities.Where(a => a.IsChecked).ForEach(a => entry.Facilities.Add(a.Item));
                model.LoggedUser = loggedUser;
                if (entry.Facilities.Any())
                {
                    List<WhiteboardReportConfigEntry> existingEntries = FacadeManager.ConfigurationInterface.GetWhiteboardReportEntries(this.loggedUser.Domain).ToList<WhiteboardReportConfigEntry>();
                    List<WhiteboardReportConfigEntry> dublicatedEntries = new List<WhiteboardReportConfigEntry>();
                    if (existingEntries != null || existingEntries.Count != 0)
                    {

                        foreach (WhiteboardReportConfigEntry existingEntry in existingEntries)
                        {
                            dublicatedEntries.AddRange((from existingFacility in existingEntry.Facilities
                                                        where (from newEntry in entry.Facilities select newEntry.Id.extension).Contains(existingFacility.Id.extension)
                                                        select new WhiteboardReportConfigEntry
                                                        {
                                                            Calendar = existingEntry.Calendar,
                                                            Facilities = new List<Facility>() { new Facility { Code = existingFacility.Code, Id = existingFacility.Id, Name = ((existingFacility.Address1 != null) ? (!string.IsNullOrEmpty(existingFacility.Address1.city) ? existingFacility.Address1.city : string.Empty) : string.Empty) + " (" + existingFacility.SiteNumber + ", " + existingFacility.Code + ")" } }
                                                        }));
                        }

                        WhiteboardReportConfigEntry editExistingEntry = existingEntries.Where(a => a.Calendar.Id == model.Entry.Calendar.Id).FirstOrDefault();
                        if (editExistingEntry != null)
                        {
                            dublicatedEntries = (from duplicatedEntry in dublicatedEntries
                                                 where !(from existingFacility in editExistingEntry.Facilities select existingFacility.Id.extension).Contains(duplicatedEntry.Facilities[0].Id.extension)
                                                 select duplicatedEntry).ToList();
                        }
                    }

                    if (dublicatedEntries != null && dublicatedEntries.Count != 0)
                    {
                        AntiXssEncoder xss = new AntiXssEncoder();
                        foreach (WhiteboardReportConfigEntry dublicatedEntry in dublicatedEntries)
                        {
                            ModelState.AddModelError("", "A scheduler already exists for facility " + dublicatedEntry.Facilities[0].Name + " (" + xss.Decode(dublicatedEntry.Calendar.Name) + ").");
                        }
                    }

                    else
                    {
                        FacadeManager.ConfigurationInterface.SaveWhiteboardReportEntry(entry, loggedUser.Domain);
                        return RedirectToAction("Index");
                    }
                }
                else
                {

                    ModelState.AddModelError("", "Select at least one facility.");

                }
                ViewBag.WhiteboardReportSelectedBackgroundColor = Strings.AnchorBackgroundColor;
                TempData.Put<string>("schedulerId", model.Entry.Calendar.Id);
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult Delete(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                ViewBag.WhiteboardReportSelectedBackgroundColor = Strings.AnchorBackgroundColor;
                AdminWhiteboardReportViewModel model = new AdminWhiteboardReportViewModel();
                model.Entry = new WhiteboardReportConfigEntry();
                JobCalendar jobCalendar = new JobCalendar() { Id = QueryStrings["calendarId"] };
                WhiteboardReportConfigEntry entry = FacadeManager.ConfigurationInterface.GetWhiteboardReportEntries(loggedUser.Domain).Where(s => s.Calendar.Id == jobCalendar.Id).Single();
                jobCalendar.Name = entry.Calendar.Name;
                model.Entry.Calendar = jobCalendar;
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Delete([Bind(Exclude = "RememberMe")] AdminWhiteboardReportViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.ConfigurationInterface.DeleteWhiteboardReportEntry(model.Entry.Calendar.Id, loggedUser.Domain);
                return RedirectToAction("Index");
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
