﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using System.Web.Security;
using Microsoft.Web.Mvc;
using BMS.Web.Models;
using BMS.Utils;
using BMS.Facade.Data;
using BMS.Facade;
using InfoWorld.HL7.ITS;
using BMS.Web.Controllers.Shared;
using BMS.Facade.Fault;
using System.ServiceModel;
using BMS.Security.DurableIssuedToken;
using BMS.Authentication;
using BMS.Web.App_GlobalResource;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Text;

namespace BMS.Web.Controllers
{
    [ValidateInput(false)]
    public class AdminIconController : BaseController
    {
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Index()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminIconViewModel model = new AdminIconViewModel();
                List<IconInfo> icons = FacadeManager.IconInterface.GetAllGlobalIcons();
                if (icons != null && icons.Count > 0)
                {
                    model.SystemIconList = icons.Where(a => a.Group.Equals(Constants.APPLICATION_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.SYSTEM_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.SystemIconList = (from p in model.SystemIconList
                                            orderby p.OrderIndex
                                            select p).ToList();
                    model.BedCleaningIconList = icons.Where(a => a.Group.Equals(Constants.APPLICATION_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.BED_CLEANING_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.BedCleaningIconList = (from p in model.BedCleaningIconList
                                                 orderby p.OrderIndex
                                                 select p).ToList();
                    model.StandardIconList = icons.Where(a => a.Group.Equals(Constants.WHITEBOARD_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.STANDARD_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.StandardIconList = (from p in model.StandardIconList
                                              orderby p.OrderIndex
                                              select p).ToList();
                    model.EmergencyIconList = icons.Where(a => a.Group.Equals(Constants.WHITEBOARD_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.EMERGENCY_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.EmergencyIconList = (from p in model.EmergencyIconList
                                               orderby p.OrderIndex
                                               select p).ToList();
                    model.SiteConfigurableIconList = icons.Where(a => a.Group.Equals(Constants.WHITEBOARD_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Subgroup.Equals(Constants.SITE_CONFIGURABLE_ICON, StringComparison.InvariantCultureIgnoreCase)).ToList();
                    model.SiteConfigurableIconList = (from p in model.SiteConfigurableIconList
                                                      orderby p.OrderIndex
                                                      select p).ToList();
                    model.PatientIcon = model.SystemIconList.Where(a => a.IconType.code.Equals(Constants.PATIENT_ICON_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                    model.RoomBedIcon = model.SystemIconList.Where(a => a.IconType.code.Equals(Constants.ROOM_BED_ICON_CODE, StringComparison.InvariantCultureIgnoreCase)).FirstOrDefault();
                }
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Index([Bind(Exclude = "RememberMe")] AdminIconViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.IconInterface.SwitchIcons(input.SwitchIconId1, input.SwitchIconId2, null, input.SwitchGroup);
                return Index();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute(OperationOverride="AdminIcon, Index")]
        public JsonResult ReSort([Bind(Exclude = "RememberMe")] AdminIconSortViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.IconInterface.UpdateIconOrder(model.GetIDs(), model.Group, model.SubGroup);
                return new JsonResult() { Data = "Success" };
            }
            catch (Exception ex)
            {
                return new JsonResult() { Data = ex.ToString() };
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult Edit(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return View(FillModelForEdit(Int32.Parse(QueryStrings["id"]), QueryStrings["group"], QueryStrings["subgroup"], false));
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Edit(AdminIconViewModel input, HttpPostedFileBase file)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                input.LoggedUser = loggedUser;
                if (!string.IsNullOrEmpty(input.ButtonSaveIcon))
                {
                    if (!ModelState.IsValid)
                    {
                        input.Active = input.ActiveHidden;
                        input.Published = input.PublishedHidden;
                        return View(input);
                    }

                    if (input.Active)
                    {
                        List<IconInfo> icons = FacadeManager.IconInterface.GetAllGlobalIcons();
                        if (icons.Where(a => (!string.IsNullOrEmpty(a.IconDescription)) && a.IconDescription.Trim().Equals(input.IconShortDescription.Trim(), StringComparison.InvariantCultureIgnoreCase) && a.Active && a.IconId != input.IconId).FirstOrDefault() != null)
                        {
                            ModelState.Clear();
                            ModelState.AddModelError("IconShortDescription", "The Icon Short Description field must be unique!");
                            return View(input);
                        }
                    }
                    if (IsValidImage(input.ImageBytes) && IsValidImage(input.ImageBytesInactive))
                    {
                        SaveIcon(input);
                        return View("SaveConfirmation", input);
                    }
                    else
                    {
                        ModelState.AddModelError("ImageName", "The image that you entered is incorrect, please re-enter it!");
                        return View("Edit", input);
                    }
                }
                else if (!string.IsNullOrEmpty(input.ButtonDeleteIcon))
                    return this.RedirectToAction<AdminIconController>(act => act.Delete(EncryptQueryString(new string[] { "id", "subgroupDisplay", "groupDisplay" }, new string[] { input.IconId.ToString(), input.SubgroupDisplay, input.GroupDisplay }, loggedUser.Salt)));
                else if (!string.IsNullOrEmpty(input.ButtonUploadImage))
                    return UploadImage(input, file);

                return null;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult Delete(string p)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminIconViewModel model = new AdminIconViewModel();
                model.IconId = Int32.Parse(QueryStrings["id"]);
                IconDetail icon = FacadeManager.IconInterface.GetIconDetail(model.IconId, null);
                model.IconName = icon.IconName;
                model.SubgroupDisplay = QueryStrings["subgroupDisplay"];
                model.GroupDisplay = QueryStrings["groupDisplay"];
                model.LoggedUser = loggedUser;
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [UpdatePermissionAuthFilterAttribute]
        public ActionResult Delete([Bind(Exclude = "RememberMe")] AdminIconViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                FacadeManager.IconInterface.DeleteIconDetail(input.IconId, null);
                AntiXssEncoder xss = new AntiXssEncoder();
                input.IconName = xss.Decode(input.IconName);
                input.LoggedUser = loggedUser;
                return View("DeleteConfirmation", input);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult Search()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminIconViewModel model = new AdminIconViewModel();
                FillModelForSearch(model);
                return View(model);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [HttpPost]
        [ReadPermissionAuthFilterAttribute]
        public ActionResult Search([Bind(Exclude = "RememberMe")] AdminIconViewModel input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                StringBuilder iconFlagIds = new StringBuilder();
                foreach (SearchIconModel icon in input.SearchIconsList)
                {
                    if (icon.IsSelected)
                    {
                        iconFlagIds.Append(icon.IconId);
                        iconFlagIds.Append(",");
                    }
                }
                input.SearchIconFlagIds = iconFlagIds.ToString();
                input.SearchResultIcons = FacadeManager.IconInterface.SearchIcons(input.SearchIconFlagIds);
                input.LoggedUser = loggedUser;
                return View("SearchResult", input);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        [ReadPermissionAuthFilterAttribute]
        public ActionResult ViewIconReport()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IList<IReportInfo> listReports = FacadeManager.ReportsInterface.GetOtherReports();
                IReportInfo report = null;

                if (listReports.Count > 0)
                    report = listReports.Where(rpt => rpt.Name == Constants.ICON_USAGE_RPT).FirstOrDefault();

                //Redirect to the report
                if (report == null)
                    throw new ReportRenderException(Constants.ICON_USAGE_RPT, Strings.ERR_ReportNotAvailable);
                else
                {
                    if (report.Parameters == null)
                        report.Parameters = new Dictionary<string, string>();

                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_PATH, Url.Action("Index", "AdminIcon"));
                    report.Parameters.Add(Constants.REP_GENERAL_RETURN_TEXT, Strings.ReturnToAddEditIconPage);
                    report.Parameters.Add(Constants.REPORT_TITLE, Strings.ImageUsageReportTitle);
                    return Redirect(report.Url);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #region Private Methods

        private AdminIconViewModel FillModelForEdit(int iconId, string group, string subgroup, bool isUpload)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                AdminIconViewModel model = new AdminIconViewModel();
                model.IconId = iconId;
                model.LoggedUser = this.loggedUser;
                if (iconId <= 0)
                {
                    model.Group = group;
                    model.Subgroup = subgroup;
                    model.IsNew = true;
                }
                else
                {
                    IconDetail iconDetail = FacadeManager.IconInterface.GetIconDetail(iconId, null);
                    if (iconDetail != null)
                    {
                        model.Active = iconDetail.Active;
                        model.ActiveHidden = model.Active;
                        model.Comment = iconDetail.Comment;
                        model.Group = iconDetail.Group;
                        model.IconLongDescription = iconDetail.LongDescription;
                        model.IconName = iconDetail.IconName;
                        model.IconShortDescription = iconDetail.ShortDescription;
                        model.ImageBytes = iconDetail.ImageBytes;
                        model.ImageBytesInactive = iconDetail.ImageBytesInactive;
                        model.ImageName = iconDetail.ImageName;
                        model.MouseOverText = iconDetail.MouseOverText;
                        model.PatientOrRoomBed = (iconDetail.PatientOrRoomBed.Equals('P')) ? true : false;
                        model.Subgroup = iconDetail.Subgroup;
                        model.OrderIndex = iconDetail.OrderIndex;
                        model.Published = (iconDetail.Published.HasValue) ? iconDetail.Published.Value : false;
                        model.PublishedHidden = model.Published;
                        model.IsIconAssociated = iconDetail.IsAssociated;
                        model.IsNew = false;
                    }
                }
                SetGroupsDisplay(model);
                return model;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void SetGroupsDisplay(AdminIconViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                switch (model.Group)
                {
                    case Constants.APPLICATION_ICON:
                        {
                            model.GroupDisplay = Strings.ApplicationIcon;
                            switch (model.Subgroup)
                            {
                                case Constants.SYSTEM_ICON:
                                    model.SubgroupDisplay = Strings.SystemIcon;
                                    break;
                                case Constants.BED_CLEANING_ICON:
                                    model.SubgroupDisplay = Strings.BedCleaningIcon;
                                    break;
                            }
                            break;
                        }
                    case Constants.WHITEBOARD_ICON:
                        {
                            model.GroupDisplay = Strings.WardWhiteboardStatusIcon;
                            switch (model.Subgroup)
                            {
                                case Constants.STANDARD_ICON:
                                    model.SubgroupDisplay = Strings.StandardIcon;
                                    break;
                                case Constants.EMERGENCY_ICON:
                                    model.SubgroupDisplay = Strings.EmergencyManagementIcon;
                                    break;
                                case Constants.SITE_CONFIGURABLE_ICON:
                                    model.SubgroupDisplay = Strings.SiteConfigurableIcon;
                                    break;
                            }
                            break;
                        }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }



        private ActionResult UploadImage(AdminIconViewModel input, HttpPostedFileBase file)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (input.IconId <= 0)
                    input.IsNew = true;
                else
                    input.IsNew = false;
                SetGroupsDisplay(input);
                ModelState.Clear();
                if (file != null && file.ContentLength > 0)
                {
                    string fileName = Path.GetFileName(file.FileName);
                    if (!Path.GetExtension(fileName).Equals(".png", StringComparison.InvariantCultureIgnoreCase) && !Path.GetExtension(fileName).Equals(".jpg", StringComparison.InvariantCultureIgnoreCase))
                    {
                        ModelState.AddModelError("ImageName", "The image file type must be .png or .jpg!");
                        return View("Edit", input);
                    }
                    if (file.ContentLength > 1000000)
                    {
                        ModelState.AddModelError("ImageName", "The image file size must be less than or equal to 1MB!");
                        return View("Edit", input);
                    }
                    //original image
                    Image imgOriginal = null;
                    try
                    {
                        imgOriginal = Image.FromStream(file.InputStream);
                    }
                    catch
                    {
                        ModelState.AddModelError("ImageName", "The image that you entered is incorrect, please re-enter it!");
                        return View("Edit", input);
                    }
                    if (imgOriginal.Height > 768 || imgOriginal.Width > 1024)
                    {
                        ModelState.AddModelError("ImageName", "The image width and height must be less than or equal to 1024x768px!");
                        return View("Edit", input);
                    }
                    if (imgOriginal.Height > 50 || imgOriginal.Width > 50)
                        ViewBag.Warning = Strings.ImageWarning;
                    input.ImageName = fileName;
                    byte[] imageBytes;
                    string bytes = string.Empty;
                    int width = 20, height = 20;
                    //resize original image
                    Bitmap b = new Bitmap(width, height);
                    Graphics g = Graphics.FromImage((Image)b);
                    g.InterpolationMode = InterpolationMode.HighQualityBicubic;
                    g.DrawImage(imgOriginal, 0, 0, width, height);
                    imgOriginal = (Image)b;
                    // inactive image(grayscale)
                    Bitmap imgInactive = MakeGrayscaleImage(b);
                    //extract bytes for the original image
                    using (MemoryStream ms = new MemoryStream())
                    {
                        imgOriginal.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                        imgOriginal.Dispose();
                        imageBytes = ms.ToArray();
                    }
                    input.ImageBytes = Convert.ToBase64String(imageBytes);
                    //extract bytes for the inactive image
                    using (MemoryStream ms = new MemoryStream())
                    {
                        imgInactive.Save(ms, System.Drawing.Imaging.ImageFormat.Png);
                        imgInactive.Dispose();
                        imageBytes = ms.ToArray();
                    }
                    input.ImageBytesInactive = Convert.ToBase64String(imageBytes);


                    return View("Edit", input);
                }
                else
                {
                    ModelState.AddModelError("ImageName", "The image file is required!");
                    return View("Edit", input);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private Bitmap MakeGrayscaleImage(Bitmap original)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //create a blank bitmap the same size as original
                Bitmap newBitmap = new Bitmap(original.Width, original.Height);

                //get a graphics object from the new image
                Graphics g = Graphics.FromImage(newBitmap);

                //create the grayscale ColorMatrix
                ColorMatrix colorMatrix = new ColorMatrix(
                   new float[][]
                      {
                         new float[] {.3f, .3f, .3f, 0, 0},
                         new float[] {.59f, .59f, .59f, 0, 0},
                         new float[] {.11f, .11f, .11f, 0, 0},
                         new float[] {0, 0, 0, 1, 0},
                         new float[] {0, 0, 0, 0, 1}
                      });

                //create some image attributes
                ImageAttributes attributes = new ImageAttributes();

                //set the color matrix attribute
                attributes.SetColorMatrix(colorMatrix);

                //draw the original image on the new image
                //using the grayscale color matrix
                g.DrawImage(original, new Rectangle(0, 0, original.Width, original.Height),
                   0, 0, original.Width, original.Height, GraphicsUnit.Pixel, attributes);

                //dispose the Graphics object
                g.Dispose();
                return newBitmap;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private AdminIconViewModel ValidateImage(AdminIconViewModel model)
        {
            return model;
        }

        private bool IsValidImage(string byteArray)
        {
            bool result = true;
            Image image = null;
            try
            {
                byte[] imageBytes = Convert.FromBase64String(byteArray);
                MemoryStream ms = new MemoryStream(imageBytes, 0, imageBytes.Length);
                ms.Write(imageBytes, 0, imageBytes.Length);
                image = Image.FromStream(ms, true);
            }
            catch
            {
                result = false;
            }
            finally
            {
                if (image != null)
                    image.Dispose();
            }
            return result;
        }

        private void SaveIcon(AdminIconViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                IconDetail icon = null;
                if (model.IsNew)
                    icon = new IconDetail();
                else
                    icon = FacadeManager.IconInterface.GetIconDetail(model.IconId, null);
                if (model.Group.Equals(Constants.APPLICATION_ICON, StringComparison.InvariantCultureIgnoreCase))
                {
                    icon.Active = true;
                    icon.Published = true;
                    icon.PatientOrRoomBed = null;
                }
                else
                {
                    icon.Active = model.ActiveHidden;
                    icon.Published = model.PublishedHidden;
                    icon.PatientOrRoomBed = (model.PatientOrRoomBed) ? 'P' : 'R';
                }
                icon.Comment = model.Comment;
                icon.EnteredBy = this.loggedUser.UserName;
                icon.EnteredDate = DateTime.UtcNow;
                icon.Group = model.Group;
                icon.IconName = model.IconName;
                icon.ImageBytes = model.ImageBytes;
                icon.ImageBytesInactive = model.ImageBytesInactive;
                icon.ImageName = model.ImageName;
                icon.LastEditBy = this.loggedUser.UserName;
                icon.LastEditDate = DateTime.UtcNow;
                icon.LongDescription = model.IconLongDescription;
                icon.MouseOverText = model.MouseOverText;
                icon.OrderIndex = model.OrderIndex;
                icon.ShortDescription = model.IconShortDescription;
                icon.Subgroup = model.Subgroup;
                if (model.IsNew)
                    FacadeManager.IconInterface.CreateIconDetail(icon);
                else
                    FacadeManager.IconInterface.UpdateIconDetail(icon);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        private void FillModelForSearch(AdminIconViewModel model)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<IconInfo> list = FacadeManager.IconInterface.GetAllGlobalIcons().Where(a => a.Subgroup.Equals(Constants.SITE_CONFIGURABLE_ICON, StringComparison.InvariantCultureIgnoreCase) && a.Active).ToList();
                model.SearchIconsList = new List<SearchIconModel>();
                SearchIconModel sIcon = null;
                foreach (IconInfo iIcon in list)
                {
                    sIcon = new SearchIconModel()
                    {
                        IconId = iIcon.IconId,
                        IconName = iIcon.IconName,
                        ImageBytes = iIcon.ImageBytes,
                        IsSelected = false,
                        IconDescription = iIcon.IconDescription,
                        MouseOverText = iIcon.MouseOverText,
                        ImageName = iIcon.ImageName
                    };
                    model.SearchIconsList.Add(sIcon);
                }
                model.LoggedUser = loggedUser;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        #endregion
    }
}
