﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data.WaitingList;
using BMS.VistaWorker2.Writer;
using BMS.VistaIntegration.VistA;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.LogCheckers;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.Security;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class WaitingListProcessor : SingleEntryProcessor<WaitingListItem>
    {
        private readonly IVistAQuery query;
        private readonly string vistaCode;
        private HashSetLogChecker logChecker;
        private bool firtTime = true;

        public WaitingListProcessor(IWriterManager writerManager, Parameter parameter, IVistAQuery query)
            : base(writerManager, parameter)
        {
            this.query = query;
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            vistaCode = EISFactory.InstanceWindows.GetVistaSite(new InfoWorld.HL7.ITS.II(domain, writerManager.Site.Id)).Code;
        }

        private IList<WaitingListItem> GetItems(Parameter p)
        {
            if (!firtTime) 
                return null;

            firtTime = false;
            IList<ScheduledAdmission> scheduledAdmissions = query.GetScheduledAdmissions(p.StartDateParam, p.EndDateParam);
            if (scheduledAdmissions == null) return null;
            var waitingList = scheduledAdmissions.Select(s => new BMS.VistaIntegration.Data.WaitingList.WaitingListItem() { ScheduledAdmission = s }).ToList();
            logChecker = new HashSetLogChecker(waitingList.Select(VistaIntegrationLogFactory.MakeWaitingListLog), vistaCode);
            return waitingList;
        }

        public void Init()
        {
            this.Init(GetItems);
            if (entityWriter != null) entityWriter.LogChecker = logChecker;
        }
    }
}
