﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer;
using System.Threading;

namespace BMS.VistaIntegration.Operations.Concrete.EntryProcessors
{
    public class ListEntryProcessor<T> : IEntryProcessor
    {
        private IEntityWriter<T> entityWriter;
        public int RetrievedEntries { get; set; }
        public bool HasMoreEntries { get; private set; }
        public int BulkCount { get; private set; }
        public IList<T> Entries { get; set; }
        public Func<T, DateTime?> FilterDateTimeFunc { get; private set; }
        private int index = 0;

        public ListEntryProcessor(IWriterManager writerManager, IList<T> entries, Func<T, DateTime?> filterDateTimeFunc = null)
        {
            FilterDateTimeFunc = filterDateTimeFunc ?? ((t) => null);
            Entries = entries;
            HasMoreEntries = entries.Count > 0;
            RetrievedEntries = entries.Count;
            if (HasMoreEntries) entityWriter = writerManager.MakeEntityWriter<T>();

        }

        private T Entry { get { return Entries[index]; } }

        public string ProcessNextEntry()
        {
            if (!HasMoreEntries)
                throw new InvalidOperationException();

            if (index < Entries.Count)
            {
                T entry = Entries[index];
                Interlocked.Increment(ref index);
                HasMoreEntries = index < Entries.Count;
                return entityWriter.Update(entry) ? typeof(T).Name : null;
            }
            else
            {
                HasMoreEntries = false;
                return null;
            }
        }

        public DateTime? EntryFilterDateTime { get { return FilterDateTimeFunc(Entry); } }

        public void Dispose()
        {
            if (entityWriter != null) entityWriter.Dispose();
        }

        public void InitLogCheck(VistaWorker2.Writer.Implementation.Concrete.IVistaIntegrationLogChecker logChecker)
        {
            if (entityWriter != null) entityWriter.LogChecker = logChecker;
        }
    }
}
