﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker2.Writer.Implementation.Concrete;
using BMS.DataContracts;
using BMS.VistaIntegration.Data;
using BMS.VistaWorker2.Writer;
using BMS.ServicesWrapper.BMService;

namespace BMS.VistaIntegration.LogCheckers
{
    public class HashSetLogChecker : IVistaIntegrationLogChecker
    {
        private readonly HashSet<VistaIntegrationLog> hashSet;

        public HashSetLogChecker(IEnumerable<VistaIntegrationLog> logs, string vistaSite)
        {
            if (!logs.Any())
                hashSet = new HashSet<VistaIntegrationLog>();
            else
            {
                IList<VistaIntegrationLog> existsLogs = BMSFactory.BedManagerQueryClientWindows.GetAlreadyExistsVistaIntegrationLogs(logs, vistaSite);
                hashSet = new HashSet<VistaIntegrationLog>(existsLogs);
            }
        }



        public bool Exists(VistaIntegrationLog log, string vistaCode)
        {
            return hashSet.Contains(log);
        }
    }
}
