﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2;
using BMS.VistaIntegration.Dal.Schedulers;
using BMS.ServicesWrapper.EIS;
using BMS.VistaIntegration.Dal;
using BMS.VistaIntegration.VistA;
using BMS.Schedulers;
using BMS.Schedulers.DateTimeValidators;
using BMS.Schedulers.DateTimeValidators.CalendarValidators;
using BMS.Schedulers.DateTimeValidators.TimerValidators;
using BMS.VistaIntegration.Commands;

namespace BMS.VistaIntegration.Mock
{
    public class SchedulerDalMock : ISchedulerDal
    {
        private const VistaDataType VISTA_TYPE = VistaDataType.OrganizationalStructure;
        private const string vistaCode = "V02UNY";

        public IList<Scheduler> GetSchedulers(Crawler crawler)
        {

            IDateTimeValidator everyDay = new DailyRecurs(1);
            IDateTimeValidator everyMinute = new OccursEveryMinute(1, TimeSpan.FromHours(0), TimeSpan.FromHours(23));
            Scheduler scheduler = new Scheduler("1")
            {
                Name = "TestScheduler",
                DateTimeValidator = everyDay.And(everyMinute)
            };

            var site = EISFactory.InstanceWindows.GetVistaSiteByCode(vistaCode);

            VistAConnectionInfo connection = new VistAConnectionInfo(
                new Data.VistASite(site.Id.extension, site.Name),
                "<DataSource modality=\"HIS\" protocol=\"VISTA\" source=\"192.168.100.156\" status=\"active\" port=\"9200\"/>",
                ".Vista.Pass.",
                 "123.ABC.");

            IVistASessionFactory sessionFactory = new MdwsVistASessionFactory();
            SchedulerData data = new SchedulerData(connection, sessionFactory, VISTA_TYPE);
            IEnumerable<SchedulerData> datas = new List<SchedulerData>() { data };
            scheduler.Command  = new RunSchedulerCommand(crawler, datas  );
            return new List<Scheduler>() { scheduler };

        }


        public void RefreshSchedulersData(Crawler crawler,IEnumerable<Scheduler> schedulers)
        {
        }
    }
}
