﻿using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Collections.Generic;
using BMS.Schedulers.DateTimeValidators.CalendarValidators;


namespace BMS.VistaIntegration.UnitTesting.Schedulers
{

    [TestClass()]
    public class MonthlyRecursTest
    {


        [TestMethod()]
        public void IsValidRecursEvery1Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 1;
            MonthlyRecurs.RunOnDay runOn = new MonthlyRecurs.RunOnDay(10);
            MonthlyRecurs target = new MonthlyRecurs( recursEvery, runOn);
            target.Init(dateTimeStarted);
            for (int i = 0; i < 1000; i++)
            {
                DateTime value = dateTimeStarted.AddDays(i);
                bool expected = value.Day == runOn.DayIndex;
                bool actual = target.IsValid(value);
                Assert.AreEqual(expected, actual);
            }
        }

        [TestMethod()]
        public void IsValidRecursEvery1Test2()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 1;
            MonthlyRecurs.RunOnDay runOn = new MonthlyRecurs.RunOnDay(10);
            MonthlyRecurs target = new MonthlyRecurs( recursEvery, runOn);
            target.Init(dateTimeStarted);
            Assert.IsTrue(target.IsValid(new DateTime(2012, 1, 10, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2012, 2, 10, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2012, 3, 10, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2012, 4, 10, 1, 1, 1)));
        }

      

        [TestMethod()]
        public void IsValidRecursEvery3Test()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 3;
            MonthlyRecurs.RunOnDay runOn = new MonthlyRecurs.RunOnDay(10);
            MonthlyRecurs target = new MonthlyRecurs( recursEvery, runOn);
            target.Init(dateTimeStarted);
            Assert.IsTrue(target.IsValid(new DateTime(2012, 3, 10, 1, 1, 1)));
            for (int i = 0; i < 1000; i++)
            {
                DateTime value = dateTimeStarted.AddDays(i);
                bool expected = (value.Month - dateTimeStarted.Month + 1) % recursEvery == 0;
                expected &= value.Day == runOn.DayIndex;
                bool actual = target.IsValid(value);
                Assert.AreEqual(expected, actual, i.ToString());
            }
        }

        [TestMethod()]
        public void IsValidRecursEvery3Test2()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 3;
            MonthlyRecurs.RunOnDay runOn = new MonthlyRecurs.RunOnDay(4);
            MonthlyRecurs target = new MonthlyRecurs( recursEvery, runOn);
            target.Init(dateTimeStarted);
            Assert.IsTrue(target.IsValid(new DateTime(2012, 3, 4, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2012, 6, 4, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2012, 9, 4, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2012, 12, 4, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2013, 3, 4, 1, 1, 1)));
            Assert.IsTrue(target.IsValid(new DateTime(2013, 6, 4, 1, 1, 1)));
        }

        [TestMethod()]
        public void IsValidRecursEvery3RunOnDayOfWeekTest()
        {
            DateTime dateTimeStarted = new DateTime(2012, 1, 1, 1, 1, 1);
            int recursEvery = 3;
            MonthlyRecurs.RunOnDay runOn = new MonthlyRecurs.RunOnDay(3,DayOfWeek.Monday);
            MonthlyRecurs target = new MonthlyRecurs(recursEvery, runOn);
            target.Init(dateTimeStarted);
            IList<DateTime> validDates = new DateTime[]
            {
                new DateTime(2012, 3, 19, 1, 1, 1),
                new DateTime(2012, 6, 18, 1, 1, 1),
                new DateTime(2012, 9, 17, 1, 1, 1),
                new DateTime(2012, 12, 17, 1, 1, 1),
                new DateTime(2013, 3, 18, 1, 1, 1),
                new DateTime(2013, 6, 17, 1, 1, 1),
                new DateTime(2013, 9, 16, 1, 1, 1)
            };

            foreach (var d in validDates) Assert.IsTrue(target.IsValid(d));

            target = new MonthlyRecurs(recursEvery, runOn);
            target.Init(dateTimeStarted);

            for(int i = 0;;i++)
            {
                DateTime d = dateTimeStarted.AddDays(i);
                if (d > validDates[validDates.Count - 1]) break;
                bool expected = validDates.Contains(d);
                bool actual = target.IsValid(d);
                Assert.AreEqual(expected, actual);
            }

        }
    }
}
