﻿//using Microsoft.VisualStudio.TestTools.UnitTesting;
//using System;
//using BMS.VistaIntegration.Operations;
//using BMS.VistaIntegration.Data;
//using System.Collections.Generic;
//using FakeItEasy;
//using BMS.VistaWorker2.Writer;
//using System.Linq;
//using System.Linq.Expressions;
//using BMS.VistaIntegration.VistA;
//using BMS.VistaIntegration.Operations.Concrete.EntryProcessors;


//namespace BMS.VistaIntegration.UnitTesting.Operations
//{


//    [TestClass()]
//    public class WorkFlowProcessorTest
//    {
//        public readonly DateTime StartDate = DateTime.Now.AddDays(-1000);
//        public readonly DateTime EndDate = DateTime.Now;
//        private const int BulkCount = 100;
//        private const int MaxSize = 1000;

//        private Random rnd = new Random();

//        private DateTime GetRandomDate(DateTime from, DateTime to)
//        {
//            TimeSpan range = new TimeSpan(to.Ticks - from.Ticks);
//            return from + new TimeSpan((long)(range.Ticks * rnd.NextDouble()));
//        }


//        public List<OrderAction> OrderActions { get; private set; }
//        public List<PatientAppointment> PatientAppointments { get; private set; }
//        public List<PatientMovement> PatientMovements { get; private set; }
//        public List<ScheduledAdmission> ScheduledAdmissions { get; private set; }
//        public List<Tuple<DateTime, object>> AllEntities { get; private set; }

//        private IEntityWriter<OrderAction> orderWriter;
//        private IEntityWriter<PatientAppointment> patientAppWriter;
//        private IEntityWriter<PatientMovement> patientMovWriter;
//        private IEntityWriter<ScheduledAdmission> scheduledAdmWriter;
//        private IWriterManager writerManager;

//        private List<T> InitData<T>(Action<T, DateTime> action) where T : new()
//        {
//            int count = rnd.Next(MaxSize);
//            return Enumerable.Range(0, count)
//                .Select(i =>
//                {
//                    T t = new T();
//                    DateTime dateTime = GetRandomDate(StartDate, EndDate);
//                    action(t, dateTime);
//                    return t;
//                })
//                .ToList();
//        }

//        private IEnumerable<IList<T>> GetReturnNext<T>(List<T> list)
//        {
//            List<T> returnList = new List<T>(BulkCount);
//            for (int i = 0; i < list.Count; i++)
//            {
//                if (i == BulkCount)
//                {
//                    yield return returnList;
//                    returnList = new List<T>(BulkCount);
//                }
//                returnList.Add(list[i]);
//            }
//            yield return returnList;
//            yield return null;
//        }

//        private IList<T>[] GetArrayReturnNext<T>(List<T> list)
//        {
//            IList<T>[] result = GetReturnNext(list).ToArray();
//            return result;
//        }

//        private void AddToAllEntities(DateTime dateTime, object entity)
//        {
//            AllEntities.Add(new Tuple<DateTime, object>(dateTime, entity));
//        }

//        [TestInitialize()]
//        public void InitData()
//        {
//            writerManager = A.Fake<IWriterManager>();
//            orderWriter = A.Fake<IEntityWriter<OrderAction>>();
//            patientAppWriter = A.Fake<IEntityWriter<PatientAppointment>>();
//            patientMovWriter = A.Fake<IEntityWriter<PatientMovement>>();
//            scheduledAdmWriter = A.Fake<IEntityWriter<ScheduledAdmission>>();

//            A.CallTo(() => writerManager.MakeEntityWriter<OrderAction>()).Returns(orderWriter);
//            A.CallTo(() => writerManager.MakeEntityWriter<PatientAppointment>()).Returns(patientAppWriter);
//            A.CallTo(() => writerManager.MakeEntityWriter<PatientMovement>()).Returns(patientMovWriter);
//            A.CallTo(() => writerManager.MakeEntityWriter<ScheduledAdmission>()).Returns(scheduledAdmWriter);

//            OrderActions = InitData<OrderAction>((e, d) => e.DateTimeOrdered = d);
//            PatientAppointments = InitData<PatientAppointment>((e, d) => e.AppointmentDateTime = d);
//            ScheduledAdmissions = InitData<ScheduledAdmission>((e, d) => e.ReservationDateTime = d);
//            PatientMovements = InitData<PatientMovement>((e, d) => e.EnteredOnDateTime = d);

//            AllEntities = new List<Tuple<DateTime, object>>(
//                OrderActions.Count +
//                PatientAppointments.Count +
//                ScheduledAdmissions.Count +
//                PatientMovements.Count);

//            OrderActions.ForEach(s => AddToAllEntities(s.DateTimeOrdered, s));
//            PatientAppointments.ForEach(s => AddToAllEntities(s.AppointmentDateTime, s));
//            PatientMovements.ForEach(s => AddToAllEntities(s.EnteredOnDateTime, s));
//            ScheduledAdmissions.ForEach(s => AddToAllEntities(s.ReservationDateTime, s));

//            AllEntities.Sort((x1, x2) => (int)DateTime.Compare(x1.Item1, x2.Item1));
//        }

//        private IEnumerator<object> GetEntityEnumerator()
//        {
//            return AllEntities.Select(s => s.Item2).GetEnumerator();
//        }

//        private void CheckOrderWriterCurretEntity(OrderAction entity)
//        {
//            if (entity != null)
//            {
//                A.CallTo(() => orderWriter.Update(entity)).MustHaveHappened(Repeated.Exactly.Once);
//            }
//        }

//        private void CheckPatAppWriterCurretEntity(PatientAppointment entity)
//        {
//            if (entity != null)
//            {
//                A.CallTo(() => patientAppWriter.Update(entity)).MustHaveHappened(Repeated.Exactly.Once);
//            }
//        }

//        private void CheckPatMovWriterCurretEntity(PatientMovement entity)
//        {
//            if (entity != null)
//            {
//                A.CallTo(() => patientMovWriter.Update(entity)).MustHaveHappened(Repeated.Exactly.Once);
//            }
//        }

//        private void CheckSchedAdmWriterCurretEntity(ScheduledAdmission entity)
//        {
//            if (entity != null)
//            {
//                A.CallTo(() => scheduledAdmWriter.Update(entity)).MustHaveHappened(Repeated.Exactly.Once);
//            }
//        }

//        private void CheckWriterCurretEntity(object o)
//        {
//            CheckOrderWriterCurretEntity(o as OrderAction);
//            CheckPatAppWriterCurretEntity(o as PatientAppointment);
//            CheckPatMovWriterCurretEntity(o as PatientMovement);
//            CheckSchedAdmWriterCurretEntity(o as ScheduledAdmission);
//        }

//        private void InitReturnsNext<T>(Expression<Func<IList<T>>> func, List<T> list)
//        {
//            A.CallTo(func).ReturnsNextFromSequence(GetArrayReturnNext(list));
//        }



//        [TestMethod()]
//        [DeploymentItem("BMS.VistaIntegration.dll")]
//        public void GetOrderActionFetchFuncTest()
//        {
//            Parameter param = new Parameter(Utils.VistaDataType.ADT, StartDate, EndDate);
//            IVistAQuery query = A.Fake<IVistAQuery>();

//            A.CallTo(() => query.BulkCount).Returns(BulkCount);

//            InitReturnsNext(() => query.GetOrderActions(StartDate, EndDate, null, null), OrderActions);
//            InitReturnsNext(() => query.GetPatientAppointments(StartDate, EndDate, null, null), PatientAppointments);
//            InitReturnsNext(() => query.GetPatientMovements(StartDate, EndDate), PatientMovements);
//            InitReturnsNext(() => query.GetScheduledAdmissions(StartDate, EndDate, null), ScheduledAdmissions);

//            WorkFlowProcessor processor = new WorkFlowProcessor(writerManager, param, query);

//            var entityEnumerator = GetEntityEnumerator();
//            while (processor.HasMoreEntries)
//            {
//                bool hasNext = entityEnumerator.MoveNext();
//                Assert.IsTrue(hasNext);
//                processor.ProcessNextEntry();
//                CheckWriterCurretEntity(entityEnumerator.Current);
//            }

//            Assert.IsFalse(entityEnumerator.MoveNext());
//            Assert.AreEqual(AllEntities.Count, processor.RetrievedEntries);


//        }
//    }
//}
