﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM;
using Mdws2ORM.Maps.SingleMaps;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class ListCancelOrdersCommand
    {
        public IEnumerable<string> OrderIens { get; set; }

        public List<string> Execute(ISession session)
        {
            SingleEntityMap<string> entityMap = SingleMapFactory.MakeStringEntityMap("100", "OR(100,", "5");
            List<string> result = new List<string>();

            foreach (string ien in OrderIens)
            {
                var containerStatus = session.Get(GetParamBuilder.DefaultParam, ien + ",", entityMap);
                if (containerStatus == null)
                {
                    BmsLogger logger = new BmsLogger("ListCancelOrdersCommand");
                    logger.LogFormat(BmsLogger.Level.Warning, "Order with ien {0} was not found", ien);
                }
                else
                {
                    if (!string.IsNullOrEmpty(containerStatus.Item))
                    {
                        if (containerStatus.Item != "6")
                            result.Add(ien);
                    }
                }
            }
            return result;
        }
    }
}
