﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM;
using Mdws2ORM.Maps;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Core;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.EIS
{
    public class ListPatientCommand
    {
        private const int StopSearchingDifference = 1000;
        private static BmsLogger logger = new BmsLogger("Vista Integration: ListPatientCommand: ");

        struct PatientData
        {
            public PatientData(string ien, DateTime dateEntered)
            {
                this.Ien = ien;
                this.DateEntered = dateEntered;
            }
            public readonly string Ien;
            public readonly DateTime DateEntered;
        }

        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }
        public QuerySvcSoap Client { get; set; }
        public int? MaxCount { get; set; }
        public VistASite VistaSite { get; set; }
        public string VistaPatientIen { get; set; }
        private bool hasMore = true;
        private string from;

        private IList<Patient> NoResult()
        {
            return new Patient[0];
        }

        private string Screen
        {
            get { return "I $P(^(0),U,16)"; }   
        }

        private PatientData GetEntry(ISession session, string fromIen)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("#");
            builder.Screen(Screen);
            builder.From(fromIen);
            PatientData result = RunRpc(session, builder.Build()).Value;
            long ien;
            while (!long.TryParse(result.Ien, out ien))
            {
                builder.From(result.Ien);                    
                result = RunRpc(session, builder.Build()).Value;
            }            
            return result;
        }

        private PatientData? FirstEntry(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Screen(Screen);
            builder.Index("#");
            PatientData? data = RunRpc(session, builder.Build());
            return data;
        }

        private PatientData? LastEntry(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("#");
            builder.Screen(Screen);
            builder.AppendFlags("B");
            if (!string.IsNullOrEmpty(VistaPatientIen))
                builder.From(VistaPatientIen);
            PatientData? data = RunRpc(session, builder.Build());
            
            long ien;
            while (data.HasValue && !long.TryParse(data.Value.Ien, out ien))
            {
                builder.From(data.Value.Ien);
                data = RunRpc(session, builder.Build());
            }
            return data;
        }

        private PatientData? RunRpc(ISession session, ListParam param)
        {
            IEntryQuery query = BmsSessionFactory.SessionFactory.MakeEntryQuery(Client, VistaSite);
            IFieldsParamFactory fieldsFactory = BmsSessionFactory.SessionFactory.MakeFieldsParamFactory();
            string[] fields = new string[] { ".097" };
            IList<Entry> list = query.List(new QueryParam("2", fieldsFactory.MakeListFieldsParam(fields), fields), param, VistaSite);
            if (list.Any())
            {
                Entry entry = list[0];
                string value = entry.Fields[0].Value;
                return new PatientData(entry.Ien, Converters.ToDateTime(value));
            }
            else
                return null;
        }

        public string FindIen(ISession session, string fromIen, DateTime fromDateTime, string toIen, DateTime toDateTime, DateTime findDateTime)
        {
            long from = long.Parse(fromIen);
            long to = long.Parse(toIen);

            while (to - from > StopSearchingDifference)
            {
                long middle = (to + from) / 2 - 1;
                PatientData data = GetEntry(session, middle.ToString());
                long ien = long.Parse(data.Ien);
                if (ien == to)
                    break;

                if (findDateTime <= data.DateEntered)
                    to = ien;
                else
                    from = ien;
            }
            if (from == 1)
                return string.Empty;
            return from.ToString();            
        }

        private PatientData? GetFirstPatient(ISession session, PatientData? lastPatientFromFile)
        {
            if (StartTime.HasValue && lastPatientFromFile.HasValue && StartTime.Value > lastPatientFromFile.Value.DateEntered)            
                return lastPatientFromFile;            
            else 
                return new PatientData("1", DateTime.MinValue);
        }

        private void InitFrom(ISession session)
        {
            if (StartTime.HasValue && EndTime.HasValue && StartTime.Value > EndTime.Value)
                return;

            PatientData? lastPatient = LastEntry(session);            
            PatientData? firstPatient = GetFirstPatient(session, lastPatient);            

            if (firstPatient == null || lastPatient == null)
                return;

            if (!EndTime.HasValue)            
                EndTime = DateTime.MaxValue;            

            if (!StartTime.HasValue)
            {
                from = string.Empty;
                StartTime = DateTime.MinValue;
                return;
            }

            if (StartTime.Value <= firstPatient.Value.DateEntered)
            {
                if (EndTime.Value > lastPatient.Value.DateEntered)
                    from = string.Empty;
                return;
            }

            if (StartTime.Value > lastPatient.Value.DateEntered)            
                return;            

            from = FindIen(session, firstPatient.Value.Ien, firstPatient.Value.DateEntered, lastPatient.Value.Ien, lastPatient.Value.DateEntered, StartTime.Value);
        }

        public IList<Patient> Execute(ISession session)
        {
            if (!hasMore)
                return null;

            if (from == null)
                InitFrom(session);
            
            if (from == null)
            {
                hasMore = false;
                return null;
            }

            if (!StartTime.HasValue)
                StartTime = DateTime.MinValue;
            if (!EndTime.HasValue)            
                EndTime = DateTime.MaxValue;            

            ListParamBuilder builder = new ListParamBuilder();
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());
            builder.From(from);

            List<Patient> result = new List<Patient>();
            var patients = session.List<Patient>(builder.Build());
            string last = string.Empty;
            int count = 0;
            long _vistaPatientIen = !string.IsNullOrEmpty(VistaPatientIen) ? long.Parse(VistaPatientIen) : 0;
            long actualPatientIen = 0;
            foreach (var patient in patients)
            {
                count++;
                last = patient.Entry.Ien;                
                if (patient.Entity.DateEnteredIntoFile.HasValue && patient.Entity.DateEnteredIntoFile.Value < StartTime.Value)
                    continue;
                if (patient.Entity.DateEnteredIntoFile.HasValue && patient.Entity.DateEnteredIntoFile.Value >= EndTime.Value)
                {
                    hasMore = false;
                    break;
                }
                if (_vistaPatientIen > 0)
                {
                    if (long.TryParse(patient.Entity.IEN, out actualPatientIen) && actualPatientIen >= _vistaPatientIen)
                    {
                        hasMore = false;
                        break;
                    }                    
                }
                if (!string.IsNullOrEmpty(patient.Entity.SocialSecurityNumber) && !string.IsNullOrEmpty(patient.Entity.IEN) && patient.Entity.IEN != "0")
                    result.Add(patient.Entity);
                else
                    logger.LogWarning("Patient with ssn " + patient.Entity.SocialSecurityNumber + " , ien " + patient.Entity.IEN + " and name " + patient.Entity.Name + " not added to the result(empty fields).");
            }
            from = last;
            if (hasMore)
            {
                if (!MaxCount.HasValue) hasMore = false;
                else if (count < MaxCount.Value) hasMore = false;
            }
            return result;
        }
    }
}
