﻿using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using Mdws2ORM;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.EIS
{
    public class ListAdmittedPatientsForUpdateCommand
    {
        public int? MaxCount { get; set; }

        private string GetScreen()
        {
            return "I $D(^DPT(Y,.105))";
        }

        public List<Patient> Execute(ISession session)
        {
            List<Patient> result = new List<Patient>();
            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("ACA");
            builder.Screen(GetScreen());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            bool hasMore = true;
            int size = 0, partialSize = 0;
            while (hasMore)
            {
                size = result.Count;
                result.AddRange(session.List<Patient>(builder.Build()).Select(s => s.Entity));
                partialSize = result.Count - size;
                hasMore = MaxCount.HasValue ? MaxCount.Value == partialSize : false;
                if (hasMore)
                    builder.From(result[result.Count - 1].AdmissionIen);
            }
            return result;
        }
    }
}
