﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM;
using Mdws2ORM.Maps;

namespace BMS.VistaIntegration.Mdws.Commands
{


    public abstract class BaseListCommand<T> where T : class
    {
        public BaseEntityMap<T> EntityMap { get; protected set; }

        public int? MaxCount { get; set; }
        public string From { get; set; }
        public string Last { get; protected set; }
        public bool HasMore { get; protected set; }

        public BaseListCommand()
        {
            HasMore = true;
        }

        protected virtual string GetScreen()
        {
            return string.Empty;
        }

        protected virtual void InitParamBuilder(ListParamBuilder builder)
        {
            builder.Screen(GetScreen());
            if (MaxCount.HasValue) builder.Number(MaxCount.Value.ToString());
            if (From != null) builder.From(From);
        }

        public virtual Func<T, bool> GetPredicate() { return null; }

        protected abstract List<T> GetList(ISession session, ListParam param, out Entry lastEntry);

        public virtual string GetIens()
        {
            return string.Empty;
        }

        public virtual List<T> Execute(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            InitParamBuilder(builder);
            ListParam param = builder.Build();

            Entry lastEntry;
            List<T> result = GetList(session, param, out lastEntry);
            Last = result.Any() ? GetLast(lastEntry) : From;
            HasMore = MaxCount.HasValue ? result.Count >= MaxCount.Value : false;
            return result;
        }

        protected virtual string GetLast(Entry entry)
        {
            return entry.Ien;
        }
    }
}
