﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;

namespace BMS.ServicesWrapper.EVS
{
    /// <summary>
    /// EVS Query parameters class.
    /// </summary>
    public class CodeFilterParameters
    {
        private string _vocabularyDomain;
        private string _language = "en";    //default language

        private MatchProperty _matchProperty = MatchProperty.DisplayName;
        private MatchAlgorithm _matchAlgorithm = MatchAlgorithm.IdenticalIgnoreCase;
        private string _matchText = "";
        private int _maxSelectedCodes = 1;

        /// <summary>
        /// Maximum number of concepts (codes) to retrieve from EVS.
        /// </summary>
        public int MaxSelectedCodes
        {
            get { return _maxSelectedCodes; }
            set { _maxSelectedCodes = value; }
        }
        /// <summary>
        /// Gets or sets the parameter Vocabulary (ValueSet).
        /// </summary>
        public string VocabularyDomain
        {
            get { return _vocabularyDomain; }
            set { _vocabularyDomain = value; }
        }
        /// <summary>
        /// Text to match if using search methods.
        /// </summary>
        public string MatchText
        {
            get { return _matchText; }
            set { _matchText = value; }
        }
        /// <summary>
        /// Property to match with MatchText when using search methods.
        /// </summary>
        public MatchProperty MatchProperty
        {
            get { return _matchProperty; }
            set { _matchProperty = value; }
        }
        /// <summary>
        /// The algorithm used the match the MatchText on the MatchProperty.
        /// </summary>
        public MatchAlgorithm MatchAlgorithm
        {
            get { return _matchAlgorithm; }
            set { _matchAlgorithm = value; }
        }
        /// <summary>
        /// Query Lanuague. Default is "en".
        /// </summary>
        public string Language
        {
            get { return _language; }
            set { _language = value; }
        }
    }
    /// <summary>
    /// Possible properties to use in search methods..
    /// </summary>
    public enum MatchProperty
    {
        /// <summary>
        /// Tries to match the CD code property.
        /// </summary>
        Code,
        /// <summary>
        /// /// Tries to match the CD displayName property.
        /// </summary>
        DisplayName
    }
    /// <summary>
    /// Values ofr Match algorithms
    /// </summary>
    public enum MatchAlgorithm
    {
        /// <summary>
        /// Whether it contains the searched phrase using case insensitive.
        /// </summary>
        ContainsPhraseIgnoreCase,
        /// <summary>
        /// Whether it ends with the searched phrase using case insensitive.
        /// </summary>
        EndsWithIgnoreCase,
        /// <summary>
        /// Whether it matches the exact searched phrase using case insensitive.
        /// </summary>
        IdenticalIgnoreCase,
        /// <summary>
        /// Whether it starts with the searched phrase using case insensitive.
        /// </summary>
        StartsWithIgnoreCase
    }
}

