﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Activities;
using InfoWorld.HL7.ITS;
using SC = BMS.DataContracts;
using FC = BMS.Facade.Data;
using BMS.Facade.Translators;
using BMS.ServicesWrapper.BMService;

namespace BMS.Workflows.CustomActivities
{
    public class CreateTransferEvent : CodeActivity
    {
        public InArgument<FC.Transfer> TransferEvent { get; set; }
        public OutArgument<II> TransferEventId { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                SC.Transfer transfer = this.TransferEvent.Get<FC.Transfer>(context).ToDataContract();
                transfer.OperationType = BMS.Utils.Constants.ACT_OPERATION_TYPE_EVENT;
                transfer.FlowId = context.WorkflowInstanceId;
                II transferEventId = BMSFactory.BedManagerOperationsClientFromWCF.CreateTransfer(transfer);
                this.TransferEventId.Set(context, transferEventId);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
