﻿using System;
using System.Activities;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Workflows.PropertyPromotionActivity
{
    // Note: This activity cannot be configured in the WF Designer. If you want to use the WF Designer,
    //       please use PromoteValue instead.
    public class PromoteValues : CodeActivity
    {
        public PromoteValues()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                this.ValuesToPromote = new Dictionary<string, InArgument>();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public bool ClearExistingPromotedData { get; set; }
        public IDictionary<string, InArgument> ValuesToPromote { get; set; }

        protected override void Execute(CodeActivityContext context)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PromotionPersistenceParticipant persistenceParticipant = context.GetExtension<PromotionPersistenceParticipant>();

                if (persistenceParticipant != null)
                {
                    if (this.ClearExistingPromotedData)
                    {
                        persistenceParticipant.ClearExistingPromotionData();
                    }

                    foreach (KeyValuePair<string, InArgument> promotedProperty in ValuesToPromote)
                    {
                        string propertyName = promotedProperty.Key;
                        object propertyValue = promotedProperty.Value != null ? promotedProperty.Value.Get(context) : null;
                        persistenceParticipant.AddPromotedVariable(propertyName, propertyValue);
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
