﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.DataContracts;
using VID = BMS.VistaIntegration.Data;

namespace BMS.VistaWorker2.Writer
{
    public static class VistaIntegrationLogFactory
    {
        private const string FormatDateTime = "MM/dd/yyyy HH:mm:ss";

        public static VistaIntegrationLog MakeOrderActionLog(OrderAction entity)
        {
            return new VistaIntegrationLog()
            {
                File = VistaFiles.Order,
                Ien = string.Format("{0}_{1}", entity.OrderId, entity.DateTimeOrdered.ToString(FormatDateTime))
            };
        }


        public static VistaIntegrationLog MakePatientAppointmentLog(PatientAppointment entity)
        {
            return new VistaIntegrationLog()
            {
                File = VistaFiles.PatientAppointment,
                Ien = string.Format("{0}_{1}", entity.Patient.IEN, entity.AppointmentDateTime.ToString(FormatDateTime))
            };
        }

        public static VistaIntegrationLog MakePatientMovementLog(PatientMovement entity)
        {
            return new VistaIntegrationLog()
            {
                File = VistaFiles.PatientMovement,
                Ien = entity.IEN
            };
        }

        public static VistaIntegrationLog MakeScheduledAdmissionLog(VID.ScheduledAdmission entity)
        {
            return new VistaIntegrationLog()
            {
                File = VistaFiles.ScheduledAdmission,
                Ien = entity.IEN
            };
        }

        public static VistaIntegrationLog MakeWaitingListLog(VID.WaitingList.WaitingListItem entity)
        {
            return new VistaIntegrationLog()
            {
                File = VistaFiles.WaitingList,
                Ien = entity.ScheduledAdmission.IEN
            };
        }
    }
}
