﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.Reflection;
using InfoWorld.HL7.ITS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete
{
    public static class WriterUtilities
    {
        public const char Delimiter = '_';

        private static readonly MethodInfo writeGenericFaultExceptionDetailMethodInfo = typeof(WriterUtilities).GetMethod("GetGenericFaultExceptionDetail", BindingFlags.NonPublic | BindingFlags.Static);

        public static object GetDetail(FaultException faultException)
        {
                Type type = faultException.GetType();
                return writeGenericFaultExceptionDetailMethodInfo.MakeGenericMethod(type.GetGenericArguments()).Invoke(null, new object[] { faultException });
        }

        private static object GetGenericFaultExceptionDetail<T>(FaultException faultException)
        {
                FaultException<T> faultExceptionWithDetail = (FaultException<T>)faultException;
                return faultExceptionWithDetail.Detail;
        }

       

        public static bool VistAEqual(string vistA, CD cd)
        {
                return cd.code.StartsWith(vistA);
        }


        public static string MakeCDCode(string vistA, string ien)
        {
                return string.Format("{0}{1}{2}", vistA, Delimiter, ien);
        }

        public static string GetIen(string vistA, CD cd)
        {
                return cd.code.Substring(vistA.Length + 1);

        }


    }
}
