﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using InfoWorld.HL7.ITS;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;
using FC = BMS.Facade.Data;
using BMS.VistaWorker2.Writer.Implementation.Concrete.EVS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EIS
{
    /// <summary>
    /// The ward location writer.
    /// </summary>
    class WardLocationWriter : BaseEisWriter<WardLocation, FC.Ward>
    {
        public override void InitCache()
        {
            Data.SetCacheForWard();
            Data.SetCacheForSpecialty();
        }        

        /// <summary>
        /// Adds the modifications for BMS entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        /// <param name="bmsEntity">The BMS entity.</param>
        protected override void TranslateFromVistaToBMS(WardLocation entity, FC.Ward bmsEntity)
        {
            bmsEntity.Ien = entity.IEN;
            bmsEntity.Name = entity.Name;
            bmsEntity.Specialty = InsertIfNullOrUpdateIfDirty<Specialty, CD>(entity.Specialty);
            bmsEntity.VistaSite = VistaSite;
            bmsEntity.IsCurrentlyOOS = entity.IsCurrentlyOutOfService;
        }

        protected override bool AreFieldsEqual(WardLocation entity, FC.Ward bmsEntity)
        {
            return entity.Name == bmsEntity.Name && entity.SpecialtyId == GetIen(bmsEntity.Specialty) && entity.IsCurrentlyOutOfService == bmsEntity.IsCurrentlyOOS;
        }

        private static string GetIen(CD specialty)
        {
            if (specialty == null)
                return null;
            return specialty.code;
        }

        protected override IEntityDal<FC.Ward> Dal
        {
            get { return Data.WardDal; }
        }
    }
}
