﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.VistaWorker2.Writer.Implementation.Concrete.Dal;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached
{
    public class WardCachedDal : BaseCachedDal<Ward>
    {
        public WardCachedDal(IEntityDal<Ward> dal) : base(dal) { }

        protected override Dictionary<string, Ward> InitCache()
        {
            return EIS.GetWardsByVistaSiteId(Site.Id).ToDictionary(s => s.Ien);
        }

    }
}
