﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using FC = BMS.Facade.Data;

namespace BMS.VistaWorker.Writer.Concrete.EIS
{
    /// <summary>
    /// The hosptial location writer.
    /// </summary>
    class HospitalLocationWriter : BaseEisWriter<HospitalLocation, FC.HospitalLocation>
    {
        /// <summary>
        /// Gets the BMS entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        /// <returns></returns>
        protected override FC.HospitalLocation GetBmsEntity(HospitalLocation entity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                return EIS.GetHospitalLocation(entity.IEN, VistaSite.Id);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Adds the modifications for BMS entity.
        /// </summary>
        /// <param name="entity">The entity.</param>
        /// <param name="bmsEntity">The BMS entity.</param>
        protected override void TranslateFromVistaToBMS(HospitalLocation entity, FC.HospitalLocation bmsEntity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                bmsEntity.Ien = entity.IEN;
                bmsEntity.Name = entity.Name;
                bmsEntity.VistaSite = VistaSite;
                bmsEntity.Abbrevation = entity.Abbreviation;
                bmsEntity.Telephone = entity.Telephone;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Inserts the BMS entity.
        /// </summary>
        /// <param name="bmsEntity">The BMS entity.</param>
        protected override void InsertBmsEntity(FC.HospitalLocation bmsEntity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EIS.CreateHospitalLocation(bmsEntity);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Updates the BMS entity.
        /// </summary>
        /// <param name="bmsEntity">The BMS entity.</param>
        protected override void UpdateBmsEntity(FC.HospitalLocation bmsEntity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EIS.UpdateHospitalLocation(bmsEntity);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Deletes the BMS entity.
        /// </summary>
        /// <param name="bmsEntity">The BMS entity.</param>
        protected override void DeleteBmsEntity(FC.HospitalLocation bmsEntity)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                EIS.DeleteHospitalLocation(bmsEntity.Id);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
