﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista order action entity.
    /// </summary>
    [Serializable]
    public class OrderAction
    {

        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public int OrderId { get; set; }

        /// <summary>
        /// Gets or sets the date time ordered.
        /// </summary>
        /// <value>
        /// The date time ordered.
        /// </value>
        public DateTime DateTimeOrdered { get; set; }

        /// <summary>
        /// Gets or sets the order text.
        /// </summary>
        /// <value>
        /// The order text.
        /// </value>
        public string OrderText { get; set; }

        /// <summary>
        /// Gets or sets the signature status.
        /// </summary>
        /// <value>
        /// The signature status.
        /// </value>
        public string SignatureStatus { get; set; }

        /// <summary>
        /// Gets or sets the date time signed.
        /// </summary>
        /// <value>
        /// The date time signed.
        /// </value>
        public DateTime? DateTimeSigned { get; set; }

        /// <summary>
        /// Gets or sets the signed by id.
        /// </summary>
        /// <value>
        /// The signed by id.
        /// </value>
        public int? SignedById { get; set; }

        /// <summary>
        /// Gets or sets the new name of the person.
        /// </summary>
        /// <value>
        /// The new name of the person.
        /// </value>
        public string NewPersonName { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>
        public int? ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the date time nurse verified.
        /// </summary>
        /// <value>
        /// The date time nurse verified.
        /// </value>
        public DateTime? DateTimeNurseVerified { get; set; }

        /// <summary>
        /// Gets or sets the verifying nurse id.
        /// </summary>
        /// <value>
        /// The verifying nurse id.
        /// </value>
        public int? VerifyingNurseId { get; set; }

        /// <summary>
        /// Gets or sets the date time clerk verified.
        /// </summary>
        /// <value>
        /// The date time clerk verified.
        /// </value>
        public DateTime? DateTimeClerkVerified { get; set; }

        /// <summary>
        /// Gets or sets the verifying clerk id.
        /// </summary>
        /// <value>
        /// The verifying clerk id.
        /// </value>
        public int? VerifyingClerkId { get; set; }

        /// <summary>
        /// Gets or sets the release date time.
        /// </summary>
        /// <value>
        /// The release date time.
        /// </value>
        public DateTime? ReleaseDateTime { get; set; }

        /// <summary>
        /// Gets or sets the release status.
        /// </summary>
        /// <value>
        /// The release status.
        /// </value>
        public string ReleaseStatus { get; set; }

        /// <summary>
        /// Gets or sets the signed by.
        /// </summary>
        /// <value>
        /// The signed by.
        /// </value>
        public NewPerson SignedBy { get; set; }

        /// <summary>
        /// Gets or sets the provider.
        /// </summary>
        /// <value>
        /// The provider.
        /// </value>
        public NewPerson Provider { get; set; }

        /// <summary>
        /// Gets or sets the verifying clerk.
        /// </summary>
        /// <value>
        /// The verifying clerk.
        /// </value>
        public NewPerson VerifyingClerk { get; set; }

        /// <summary>
        /// Gets or sets the verifying nurse.
        /// </summary>
        /// <value>
        /// The verifying nurse.
        /// </value>
        public NewPerson  VerifyingNurse { get; set; }

    }
}