﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.VistaWorker.Abstract
{
    /// <summary>
    /// Controller interface responsible for management of the reader manager.
    /// </summary>
    public interface IController : IDisposable
    {
        IWriterManager WriterManager { get; }

        IReaderManager ReaderManager { get; }

        /// <summary>
        ///  Start the reader manager.
        /// </summary>
        void Start();

        /// <summary>
        /// Stop the reader manager.
        /// </summary>
        void Stop();
    }
}
