﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using BMS.Utils;

namespace BMS.VistaWorker.Reader.LinqToSql
{
    public class DataContextCache : IDisposable
    {
        private  readonly static DataContextCache instance = new DataContextCache();
        public static DataContextCache Instance { get { return instance; } }
        private bool isDisposed = false;
        private Dictionary<string, VistaDataContext> dictionary = new Dictionary<string, VistaDataContext>();

        private static readonly ReaderWriterLockSlim ThisLock = new ReaderWriterLockSlim();
        
        public VistaDataContext Get(string connectionString)
        {
            VistaDataContext dataContext;
            ThisLock.EnterReadLock();
            try
            {
                if (isDisposed)
                    throw new InvalidOperationException();
                dictionary.TryGetValue(connectionString, out dataContext);
            }
            finally { ThisLock.ExitReadLock(); }
            if (dataContext == null) dataContext = AddDataContext(connectionString);
            return dataContext;

        }

        private VistaDataContext AddDataContext(string connectionString)
        {
            VistaDataContext context = new VistaDataContext(connectionString);
            ThisLock.EnterWriteLock();
            try
            {
                dictionary.Add(connectionString, context);
            }
            finally { ThisLock.ExitWriteLock(); }
            return context;
        }

        private void Dispose(VistaDataContext dataContext)
        {
            try
            {
                dataContext.Dispose();
            }
            catch(Exception e) 
            {
                Tracer.TraceException(e);
            }
        }

        public void Dispose()
        {
            ThisLock.EnterWriteLock();
            try
            {
                isDisposed = true;
                dictionary.Values.ForEach(Dispose);
            }
            finally { ThisLock.ExitWriteLock(); }
        }
    }
}
