﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Reader.LogTables;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The orders order actions log data.
    /// </summary>
    public class OrdersOrderActionsLog : ILogData
    {
        private readonly OrdersOrderActions entity = new OrdersOrderActions();

        /// <summary>
        /// Gets the crud action.
        /// </summary>
        public CrudAction CrudAction { get; private set; }

        /// <summary>
        /// Gets the entity.
        /// </summary>
        public IEntity Entity
        {
            get { return entity; }
        }

        /// <summary>
        /// Gets the id.
        /// </summary>
        public int Id { get; set; }
        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public int OrderId { get { return entity.OrderId; } set { entity.OrderId = value; } }
        /// <summary>
        /// Gets or sets the order action id.
        /// </summary>
        /// <value>
        /// The order action id.
        /// </value>
        public int OrderActionId { get { return entity.OrderActionId; } set { entity.OrderActionId = value; } }

        /// <summary>
        /// Deletes the entity.
        /// </summary>
        /// <param name="repository">The repository.</param>
        public void Delete(IRepository repository)
        {
            repository.Delete(this);
        }
    }
}
