﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using VI = BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Translators
{
    public static class Translators
    {
        public static PatientMovement ToEntity(this PatientVisit patientVisit)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                PatientMovement entity = new PatientMovement()
                {
                    PatientId = patientVisit.PatientIEN,
                    DateTime = patientVisit.RecordedDateTime.Value,
                    WardLocationId = patientVisit.AssignedWard,
                    RoomBedId = string.Format("{0}-{1}", patientVisit.AssignedRoom, patientVisit.AssignedBed),
                    EnteredById = patientVisit.AttendingDoctorIdentifier,
                    IEN = patientVisit.VisitId,
                    Patient = new Patient()
                    {
                        Name = string.IsNullOrEmpty(patientVisit.PatientGivenName) ?
                                 patientVisit.PatientFamilyName :
                                 patientVisit.PatientFamilyName + "," + patientVisit.PatientGivenName + (
                                 string.IsNullOrEmpty(patientVisit.PatientMiddleInitial) ?
                                     "" : " " + patientVisit.PatientMiddleInitial),
                        IEN = patientVisit.PatientIEN,
                        DateOfBirth = patientVisit.PatientDateOfBirth.HasValue ? patientVisit.PatientDateOfBirth.Value : DateTime.UtcNow,
                        Sex = string.IsNullOrEmpty(patientVisit.PatientGender) ? null as char? : patientVisit.PatientGender[0],
                        SocialSecurityNumber = patientVisit.PatientSSN
                    }
                };

                if (patientVisit.EventType.Equals(Constants.AdmissionEventMessageType, StringComparison.InvariantCultureIgnoreCase))
                {
                    entity.EnteredOnDateTime = patientVisit.AdmissionDateTime.Value;
                    entity.TransactionTypeId = Constants.PATIENT_MOVEMENT_TRANSACTION_ADMISSION_MIN + "";
                }
                else
                    if (patientVisit.EventType.Equals(Constants.TransferEventMessageType, StringComparison.InvariantCultureIgnoreCase))
                    {
                        entity.EnteredOnDateTime = patientVisit.AdmissionDateTime.Value;
                        entity.TransactionTypeId = Constants.PATIENT_MOVEMENT_TRANSACTION_TRANSFER_MIN + "";
                    }
                    else
                        if (patientVisit.EventType.Equals(Constants.DischargeEventMessageType, StringComparison.InvariantCultureIgnoreCase))
                        {
                            entity.EnteredOnDateTime = patientVisit.DischargeDateTime.Value;
                            entity.TransactionTypeId = Constants.PATIENT_MOVEMENT_TRANSACTION_DISCHARGE_MIN + "";
                        }

                return entity;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
