﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using System.Xml.Serialization;

namespace BMS.VistaIntegration.HL7.DataContracts
{
    [Serializable]
    [XmlType(TypeName = "HL7Event")]
    public class HL7Event
    {
        /// <summary>
        /// Gets or sets the sending facility identifier.
        /// </summary>
        /// <value>
        /// The sending facility identifier.
        /// </value>
        [XmlElementAttribute("SendingFacilityIdentifier", Order = 1)]
        public string SendingFacilityIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the patient's IEN.
        /// </summary>
        /// <value>
        /// The patient's IEN.
        /// </value>
        [XmlElementAttribute("PatientIEN", Order = 2)]
        public string PatientIEN { get; set; }

        /// <summary>
        /// Gets or sets the patient's SSN.
        /// </summary>
        /// <value>
        /// The patient's SSN.
        /// </value>
        [XmlElementAttribute("PatientSSN", Order = 3)]
        public string PatientSSN { get; set; }

        /// <summary>
        /// Gets or sets the type of the event.
        /// </summary>
        /// <value>
        /// The type of the event.
        /// </value>
        [XmlElementAttribute("EventType", Order = 4)]
        public string EventType { get; set; }

        /// <summary>
        /// Gets or sets the patient's date of birth.
        /// </summary>
        /// <value>
        /// The patient's date of birth.
        /// </value>
        [XmlElementAttribute("PatientDateOfBirth", Order = 5)]
        public string PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the admission date time.
        /// </summary>
        /// <value>
        /// The admission date time.
        /// </value>
        [XmlElementAttribute("AdmissionDateTime", Order = 6)]
        public string AdmissionDateTime { get; set; }

        /// <summary>
        /// Gets or sets the discharge date time.
        /// </summary>
        /// <value>
        /// The discharge date time.
        /// </value>
        [XmlElementAttribute("DischargeDateTime", Order = 7)]
        public string DischargeDateTime { get; set; }

        /// <summary>
        /// Gets or sets the date time the ADT event was recorded.
        /// </summary>
        /// <value>
        /// The date time the ADT event was recorded.
        /// </value>
        [XmlElementAttribute("RecordedDateTime", Order = 8)]
        public string RecordedDateTime { get; set; }
    }
}
