﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.IO;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.VistaIntegration.Exceptions;

namespace BMS.VistaIntegration.Mdws2
{
    public static class Utilities
    {
        public static Predicate<T> MakePredicate<T>(DateTime? startDate, DateTime? endDate, Func<T, DateTime> pred)
        {

            if (startDate.HasValue && endDate.HasValue)
            {
                DateTime sdate = startDate.Value;
                DateTime eDate = endDate.Value;
                return (p) =>
                    {
                        DateTime value = pred(p);
                        return value >= sdate && value < eDate;
                    };
            }

            if (startDate.HasValue)
            {
                DateTime sdate = startDate.Value;
                return (p) => pred(p) >= sdate;
            }

            if (endDate.HasValue)
            {
                DateTime eDate = endDate.Value;
                return (p) => pred(p) < eDate;
            }

            return null;
        }

        public static Exception MakeExceptionFromVistAFault(this FaultTO fault)
        {

            if (fault.type == "gov.va.medora.mdo.exceptions.NotConnectedException")
                return new VistAConnectionException();
            else
                return new InvalidOperationException(fault.message);
        }


        private const string XmlNode = "DataSource";
        private const string ModalityAttribute = "modality";
        private const string ProtocolAttribute = "protocol";
        private const string SourceAttribute = "source";
        private const string PortAttribute = "port";


        private static string ErrorMessage
        {
            get
            {



                return string.Format("The connection string is invalid for the following format: {0}", ConnectionStringFormat);

            }
        }

        private const string ConnectionStringFormat = "<DataSource modality=\"{0}\" protocol=\"{1}\" source=\"{2}\" port=\"{3}\"/>";

        internal static VistAConnectionString MakeVistAConnection(string connectionString)
        {



            using (XmlReader reader = XmlReader.Create(new StringReader(connectionString)))
            {
                try
                {
                    reader.Read();
                }
                catch (XmlException)
                {
                    throw new VistAConnectionException(ErrorMessage);
                }

                var datasource = reader.Name;
                var modality = reader[ModalityAttribute];
                var protocol = reader[ProtocolAttribute];
                var source = reader[SourceAttribute];
                var port = reader[PortAttribute];

                if (reader.Name != XmlNode)
                    throw new VistAConnectionException(ErrorMessage);
                if (string.IsNullOrEmpty(modality))
                    throw new VistAConnectionException(ErrorMessage);
                if (string.IsNullOrEmpty(protocol))
                    throw new VistAConnectionException(ErrorMessage);
                if (string.IsNullOrEmpty(source))
                    throw new VistAConnectionException(ErrorMessage);
                if (string.IsNullOrEmpty(port))
                    throw new VistAConnectionException(ErrorMessage);

                return new VistAConnectionString()
                {
                    Modality = modality,
                    Port = port,
                    Protocol = protocol,
                    Source = source
                };

            }

        }
    }
}
