﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Mdws2.Maps.EIS
{
    public class RoomBedMap : FileMap<RoomBed>
    {
        private static readonly RoomBedMap instance = new RoomBedMap();
        public static RoomBedMap Instance { get { return instance; } }

        private RoomBedMap()
        {
        }

        public override RoomBed Make()
        {
                RoomBed bed = base.Make();
                bed.WardsWhichCanAssign = new List<string>();
                bed.OutOfServiceDates = new List<DateTime>();
                return bed;
        }

        public override string FileNumber
        {
            get { return "405.4"; }
        }

        protected override void Map()
        {

                MapIen((m, s) => m.IEN = s);
                Map((m, s) => m.Name = s, ".01");
                Map((m, s) => m.CurrentlyOutOfService = s.VistAToBool(), ".2");
                MapMultiple("100", "405.41");
                Map((m, s) => m.WardsWhichCanAssign.Add(s), "405.41", ".01");
                MapMultiple("200", "405.42");
                Map((m, s) => m.OutOfServiceDates.Add(s.VistAToDateTime()), "405.42", ".01");
        }
    }


}
