﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class PatientMovementCommand : BasePeriodCommand<PatientMovement>
    {
        public PatientMovementCommand()
            : base(PatientMovementMap.Instance)
        {
        }

        public string PatientIen { get; set; }

        protected override string FieldLocation
        {
            get { return "0;1"; }
        }

        private const string PatientScreen = "I $P(^DGPM(Y,0),U,3)={0} ";

        protected override string GetScreenParam()
        {
            string screen = base.GetScreenParam();
            if (!string.IsNullOrEmpty(PatientIen))
            {
                screen = string.Format(PatientScreen, PatientIen) + screen;
            }
            return screen;
        }

    }
}
