﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Maps.WF;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Implementation.WF
{
    public class PatientAppointmentCommand : BaseCommand<PatientAppointment>
    {
        public PatientAppointmentCommand()
            : base(PatientAppointmentMap.Instance)
        { }


        public IEnumerable<string> ClinicIens { get; set; }

        private Predicate<PatientAppointment> predicate;
        protected override Predicate<PatientAppointment> GetPredicate()
        {
            return predicate; ;
        }


        public override IList<PatientAppointment> Execute(QuerySvcSoap client)
        {
            Predicate<PatientAppointment> p = Utilities.MakePredicate<PatientAppointment>(StartDate, EndDate, (e) => e.AppointmentDateTime);
            if (ClinicIens == null) predicate = p;
            else
            {
                int l = ClinicIens.Count();
                if (l == 1)
                {
                    string clinicIen = ClinicIens.First();
                    predicate = (pat) => pat.HospitalLocationId == clinicIen && p(pat);
                }
                else if (l == 0)
                {
                    return Enumerable.Empty<PatientAppointment>().ToList();
                }
                else
                {
                    HashSet<string> clinicHash = new HashSet<string>(ClinicIens);
                    predicate = (pat) => clinicHash.Contains(pat.HospitalLocationId) && p(pat);
                }
            }
            return base.Execute(client);
        }

        protected override string GetScreenParam()
        {
            if (StartDate.HasValue && EndDate.HasValue)
                return string.Format(StartEndDateScreen, StartDate.Value.VistAToInternalFormat(), EndDate.Value.VistAToInternalFormat());

            if (StartDate.HasValue)
                return string.Format(StartDateScreen, StartDate.Value.VistAToInternalFormat());

            if (EndDate.HasValue)
                return string.Format(EndDateScreen, EndDate.Value.VistAToInternalFormat());

            return string.Empty;
        }

        private const string StartDateScreen = "S x=0 S $T=0 F  S x=$O(^DPT(Y,\"S\",x)) Q:x=\"\"  I x>={0} Q";
        private const string EndDateScreen = "S x=0 S $T=0 F  S x=$O(^DPT(Y,\"S\",x)) Q:x=\"\"  I x<{0} Q";
        private const string StartEndDateScreen = "S x=0 S $T=0 F  S x=$O(^DPT(Y,\"S\",x)) Q:x=\"\"  I (x>={0})&(x<{1}) Q";


    }
}
