﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    class ReferenceFetch<T, R> : IReferenceFetch<T> where R : class,new()
    {
        private readonly Action<T, R> func;
        private readonly SingleFileFetch<R> fileFetch;


        public ReferenceFetch(Action<T, R> func, FileMap<R> fileMap)
        {
            this.func = func;
            this.fileFetch = new SingleFileFetch<R>(fileMap);
        }


        public void SetFields(QuerySvcSoap client, T entity, string ien)
        {
            fileFetch.Client = client;
            fileFetch.Ien = ien;
            R reference = fileFetch.GetResult();
            func(entity, reference);
        }

    }
}
