﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public class GetFetchCommand
    {
        public QuerySvcSoap Client { get; private set; }
        private ISingleResultMaker ResultMaker { get; set; }

        public GetFetchCommand(QuerySvcSoap client)
        {
            this.Client = client;
            InitParam();
        }

        private void InitParam()
        {
            FileParam = string.Empty;
            FieldParam = string.Empty;
        }

        public string FileParam { get; set; }
        public string FieldParam { get; set; }
        public string IenParam { get; set; }


        private TaggedTextArray RunRpc()
        {
            TaggedTextArray result = Client.GETS_DIQ(
            fileNumber: FileParam,
            iens: IenParam,
            field: FieldParam,
            flags: "NI");
            return result;
        }


        public void Execute(ISingleResultMaker resultMaker)
        {

            ResultMaker = resultMaker;
            TaggedTextArray result = RunRpc();
            if (result.fault != null)
                throw result.fault.MakeExceptionFromVistAFault();

            string text = result.results[0].text;
            if (text == "-1^No data retrieved\n")
                return;
            string[] lines = text.Split('\n');
            ResultMaker.SetIen(IenParam);
            for (int i = 0; i < lines.Length - 1; i++)
                ProcessLine(lines[i]);

        }


        private void ProcessLine(string line)
        {
            string[] values = line.Split('^');
            string fileNumber = values[0];
            string fieldIen = values[2];
            string value = values[3];
            if (value != string.Empty)
            {
                if (fileNumber == FileParam)
                    ResultMaker.SetField(fieldIen, value);
                else
                    ResultMaker.SetMultipleField(fileNumber, fieldIen, value);
            }
        }

    }
}
