﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA order action contract.
    /// </summary>
    [Serializable]
    public class OrderAction
    {
        /// <summary>
        /// Gets or sets the order id.
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>

        public string OrderId { get; set; }

        /// <summary>
        /// Gets or sets the date ordered.
        /// </summary>
        /// <value>
        /// The date ordered.
        /// </value>

        public DateTime DateTimeOrdered { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        /// <value>
        /// The provider id.
        /// </value>

        public string ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the date time signed.
        /// </summary>
        /// <value>
        /// The date time signed.
        /// </value>

        public DateTime? DateTimeSigned { get; set; }



        /// <summary>
        /// Gets or sets the date time nurse verified.
        /// </summary>
        /// <value>
        /// The date time nurse verified.
        /// </value>

        public DateTime? DateTimeNurseVerified { get; set; }

        /// <summary>
        /// Gets or sets the verifying nurse id.
        /// </summary>
        /// <value>
        /// The verifying nurse id.
        /// </value>

        public string VerifyingNurseId { get; set; }

        /// <summary>
        /// Gets or sets the date time clerk verified.
        /// </summary>
        /// <value>
        /// The date time clerk verified.
        /// </value>

        public DateTime? DateTimeClerkVerified { get; set; }

        /// <summary>
        /// Gets or sets the verifying clerk id.
        /// </summary>
        /// <value>
        /// The verifying clerk id.
        /// </value>

        public string VerifyingClerkId { get; set; }


        /// <summary>
        /// Gets or sets the release date time.
        /// </summary>
        /// <value>
        /// The release date time.
        /// </value>

        public DateTime? ReleaseDateTime { get; set; }

        /// <summary>
        /// Gets or sets the release status.
        /// </summary>
        /// <value>
        /// The release status.
        /// </value>

        public string ReleaseStatus { get; set; }



        /// <summary>
        /// Gets or sets the order text.
        /// </summary>
        /// <value>
        /// The order text.
        /// </value>

        public string OrderText { get; set; }

        public string SignedById { get; set; }

        public Order Order { get; set; }
        public NewPerson VerifyingClerk { get; set; }
        public NewPerson VerifyingNurse { get; set; }
        public NewPerson SignedBy { get; set; }
        public NewPerson Provider { get; set; }

        public string SignatureStatus { get; set; }

        public override string ToString()
        {
            return string.Format("OrderAction {0} for Order {1}", DateTimeOrdered, OrderId);
        }
    }
}
