﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA order contract.
    /// </summary>
    [Serializable]
    public class Order
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>

        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the order_.
        /// </summary>
        /// <value>
        /// The order_.
        /// </value>

        public string OrderNumber { get; set; }


        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>

        public string PatientId { get; set; }

        public string ReferralPatientId { get; set; }

        /// <summary>
        /// Gets or sets the last activity date.
        /// </summary>
        /// <value>
        /// The last activity date.
        /// </value>

        public DateTime? LastActivityDate { get; set; }

        /// <summary>
        /// Gets or sets the D c_ date.
        /// </summary>
        /// <value>
        /// The D c_ date.
        /// </value>

        public DateTime? DC_Date { get; set; }

        /// <summary>
        /// Gets or sets the hospital location id.
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>

        public string HospitalLocationId { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>

        public DateTime? StartDate { get; set; }

        /// <summary>
        /// Gets or sets the stop date.
        /// </summary>
        /// <value>
        /// The stop date.
        /// </value>

        public DateTime? StopDate { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>

        public string StatusId { get; set; }

        /// <summary>
        /// Gets or sets the display group id.
        /// </summary>
        /// <value>
        /// The display group id.
        /// </value>

        public string DisplayGroupId { get; set; }

        /// <summary>
        /// Gets or sets the order orderable item ids.
        /// </summary>
        /// <value>
        /// The order orderable item ids.
        /// </value>

        public List<string> OrderOrderableItemIds { get; set; }

        public Patient Patient { get; set; }

        public OrderStatus OrderStatus { get; set; }

        public HospitalLocation HospitalLocation { get; set; }

        public override string ToString()
        {
            return string.Format("Order {0}", IEN);
        }
    }
}
