﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA room bed contract.
    /// </summary>
    [Serializable]
    public class RoomBed : IEntity
    {
        /// <summary>
        /// Gets or sets the internal entry number.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [currently out of service].
        /// </summary>
        /// <value>
        /// 	<c>true</c> if [currently out of service]; otherwise, <c>false</c>.
        /// </value>
        public bool CurrentlyOutOfService { get; set; }

        /// <summary>
        /// Gets or sets the ward location ids.
        /// </summary>
        /// <value>
        /// The ward location ids.
        /// </value>
        public List<string> WardsWhichCanAssign { get; set; }

        private string wardsWhichCanAssignString;
        public string WardsWhichCanAssignString {
            get { return wardsWhichCanAssignString; } 
            set 
            {
                wardsWhichCanAssignString = value;
                WardsWhichCanAssign = new List<string>();
                if (!string.IsNullOrEmpty(wardsWhichCanAssignString))
                    WardsWhichCanAssign = wardsWhichCanAssignString.Split(',').ToList();
            } 
        }

        /// <summary>
        /// Gets or sets the out of service dates.
        /// </summary>
        /// <value>
        /// The out of service dates.
        /// </value>
        public IList<DateTime> OutOfServiceDates { get; set; }

        /// <summary>
        /// Gets or sets the bed hold patient ien.
        /// </summary>
        /// <value>
        /// The bed hold patient ien.
        /// </value>
        public string BedHoldPatientIen { get; set; }

        /// <summary>
        /// Gets or sets the bed hold start date.
        /// </summary>
        /// <value>
        /// The bed hold start date.
        /// </value>
        public DateTime? BedHoldStartDate { get; set; }

        /// <summary>
        /// Gets or sets the wards.
        /// </summary>
        /// <value>
        /// The wards.
        /// </value>
        public IList<WardLocation> Wards { get; set; }

        public override string ToString()
        {
            return "RoomBed:" + Name + ", Ien: " + IEN;
        }
    }
}
