﻿using System;
using System.ServiceModel;
using BMS.Utils;
using BMS.DataContracts;
using BMS.FaultContracts;
using System.Collections.Generic;

namespace BMS.ServiceContracts
{
    [ServiceContractAttribute]
    public interface IVistaWorkerQuery
    {
        [OperationContract]
        [FaultContract(typeof(VistAException))]
        void RunOnDemand(VistASite site, VistaDataType types, DateTime? startDate, DateTime? endDate, DataRetrievalMethod retrievalMethod);

        [OperationContract]
        [FaultContract(typeof(VistAException))]
        void TestConnection(VistASite site, DataRetrievalMethod retrievalMethod);

        [OperationContract]
        void SetRefreshSchedulersFlag();

        [OperationContract]
        void SetRefreshVistACommandsFlag();

        [OperationContract]
        void SetRefreshNumiCommandsFlag();

        [OperationContract]
        void SetRefreshWhiteboardReportCommandsFlag();

        [OperationContract]
        void RefreshSchedulers();

        [OperationContract]
        void RefreshVistACommands();

        [OperationContract]
        void RefreshNumiCommands();

        [OperationContract]
        void RefreshWhiteboardReportCommands();
    }
}
