﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.DataContracts
{

    public static class VistaFiles
    {
        public const string Order = "OR";
        public const string PatientMovement = "PM";
        public const string ScheduledAdmission = "SA";
        public const string PatientAppointment = "PA";
        public const string WaitingList = "WL";
    }

    [Serializable]
    [DataContract]
    public class VistaIntegrationLog : IEquatable<VistaIntegrationLog>
    {
        [DataMember]
        public string Ien { get; set; }

        [DataMember]
        public string File { get; set; }

        public override int GetHashCode()
        {
            return (Ien + File).GetHashCode();
        }

        public override bool Equals(object obj)
        {
            return Equals(obj as VistaIntegrationLog);
        }

        public bool Equals(VistaIntegrationLog other)
        {
            if (other == null) return false;
            return Ien == other.Ien &&
                File == other.File;
        }
    }

}
