﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about specialty transfers.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "SpecialtyTransfer")]
    [DataContract(Name = "SpecialtyTransfer")]
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    public class SpecialtyTransfer
    {
        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        [XmlElementAttribute("Ien", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "Ien", Order = 2)]
        public string Ien { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 3)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 4)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets the date time.
        /// </summary>
        /// <value>
        /// The date time.
        /// </value>
        [XmlElementAttribute("DateTime", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "DateTime", Order = 5)]
        public DateTime? DateTime { get; set; }

        /// <summary>
        /// Gets or sets the type of movement.
        /// </summary>
        /// <value>
        /// The type of movement.
        /// </value>
        [XmlElementAttribute("TypeOfMovement", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfMovement", Order = 6)]
        public CD TypeOfMovement { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("EnteredDate", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 7)]
        public DateTime? EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the entered by.
        /// </summary>
        /// <value>
        /// The entered by.
        /// </value>
        [XmlElementAttribute("EnteredById", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredById", Order = 8)]
        public II EnteredById { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        /// <value>
        /// The admission id.
        /// </value>
        [XmlElementAttribute("AdmissionId", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionId", Order = 9)]
        public II AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the admission ien.
        /// </summary>
        /// <value>
        /// The admission ien.
        /// </value>
        [XmlElementAttribute("AdmissionIen", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionIen", Order = 10)]
        public string AdmissionIen { get; set; }
    }
}
