﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.DataContracts;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Data about a patient waiting used in filtering BMS operations.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "PatientWaitingDateView")]
    [DataContract(Name = "PatientWaitingDateView")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(II))]
    public class PatientWaitingDateView : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the disposition date.
        /// </summary>
        /// <value>
        /// The disposition date.
        /// </value>
        [XmlElementAttribute("DispositionDate", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "DispositionDate", Order = 1)]
        public DateTime? DispositionDate { get; set; }

        /// <summary>
        /// Gets or sets the facility where the patient is transferred.
        /// </summary>
        /// <value>
        /// The admission facility.
        /// </value>
        [XmlElementAttribute("AdmissionFacilityId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionFacilityId", Order = 2)]
        public II AdmissionFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the facility from where the patient is transfered(EIS place).
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 3)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the speciality.
        /// </summary>
        /// <value>
        /// The speciality.
        /// </value>
        [XmlElementAttribute("Specialty", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "Specialty", Order = 4)]
        public string Specialty { get; set; }

        /// <summary>
        /// Gets or sets the region code.
        /// </summary>
        /// <value>
        /// The region code.
        /// </value>
        [XmlElementAttribute("RegionCode", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "RegionCode", Order = 5)]
        public string RegionCode { get; set; }

        /// <summary>
        /// Gets or sets the VISN code.
        /// </summary>
        /// <value>
        /// The VISN code.
        /// </value>
        [XmlElementAttribute("VISNCode", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "VISNCode", Order = 5)]
        public string VISNCode { get; set; }

        /// <summary>
        /// Gets or sets the event date.
        /// </summary>
        /// <value>
        /// The event date.
        /// </value>
        [XmlElementAttribute("EventDate", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "EventDate", Order = 6)]
        public DateTime? EventDate { get; set; }

        /// <summary>
        /// Gets or sets the entry by.
        /// </summary>
        /// <value>
        /// The entry by.
        /// </value>
        [XmlElementAttribute("EntryBy", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "EntryBy", Order = 7)]
        public string EntryBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        [XmlElementAttribute("LastEditBy", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditBy", Order = 8)]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the last edit date.
        /// </summary>
        /// <value>
        /// The last edit date.
        /// </value>
        [XmlElementAttribute("LastEditDate", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditDate", Order = 9)]
        public DateTime? LastEditDate { get; set; }        

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsNationalWaitList", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "IsNationalWaitList", Order = 12)]
        public bool IsNationalWaitList { get; set; }

        /// <summary>
        /// Gets or sets the transfer request date time.
        /// </summary>
        /// <value>
        /// The transfer request date time.
        /// </value>
        [XmlElementAttribute("ReqCreateDateTime", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "ReqCreateDateTime", Order = 13)]
        public DateTime? ReqCreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the transfer event date time.
        /// </summary>
        /// <value>
        /// The transfer envent date time.
        /// </value>
        [XmlElementAttribute("EvnCreateDateTime", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "EvnCreateDateTime", Order = 14)]
        public DateTime? EvnCreateDateTime { get; set; }

        #endregion
    }
}
