﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about movement orders managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "MovementOrder")]
    [DataContract(Name = "MovementOrder")]
    [KnownType(typeof(Order))]
    [KnownType(typeof(II))]
    public class MovementOrder : Order
    {
        /// <summary>
        /// Gets or sets the medical person id that schedules the movement(EIS person).
        /// </summary>
        /// <value>
        /// The scheduler id.
        /// </value>
        [XmlElementAttribute("SchedulerId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "SchedulerId", Order = 1)]
        public II SchedulerId { get; set; }
    }
}
