﻿using System;
using InfoWorld.HL7.ITS;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Main entity for all events.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Event")]
    [DataContract(Name = "OrdeEvent")]
    [KnownType(typeof(II))]
    public class Event
    {
        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the patient id on which the event is performed.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 2)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        [XmlElementAttribute("Ien", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Ien", Order = 3)]
        public string Ien { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("EnteredDate", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 4)]
        public DateTime EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the ward id where the event was created.
        /// </summary>
        /// <value>
        /// The ward id.
        /// </value>
        [XmlElementAttribute("WardId", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 5)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the bed id where the event was created.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        [XmlElementAttribute("BedId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 6)]
        public II BedId { get; set; }

        /// <summary>
        /// Gets or sets the vista site id where the event was created.
        /// </summary>
        /// <value>
        /// The vista site id.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 7)]
        public II VistaSiteId { get; set; }
    }
}
