﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;
using System.Xml.Serialization;

namespace BMS.DataContracts
{
    /// <summary>
    /// Represents a configuration entity.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "Element")]
    [DataContract(Name = "Element")]
    public class Element
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the key for identifying the configuration.
        /// </summary>
        /// <value>
        /// The key.
        /// </value>
        [XmlElementAttribute("Key", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Key", Order = 1)]
        public string Key { get; set; }

        /// <summary>
        /// Gets or sets the configuration value.
        /// </summary>
        /// <value>
        /// The value.
        /// </value>
        [XmlElementAttribute("Value", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "Value", Order = 2)]
        public ANY Value { get; set; }

        /// <summary>
        /// Gets or sets the friendly name of the configuration(description).
        /// </summary>
        /// <value>
        /// The friendly name.
        /// </value>
        [XmlElementAttribute("FriendlyName", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FriendlyName", Order = 3)]
        public string FriendlyName { get; set; }        

        #endregion

    }
}
