﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections.Generic;


namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about an unavailable history event that is raised with BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "BedUnavailableHistory")]
    [DataContract(Name = "BedUnavailableHistory")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(II))]
    [KnownType(typeof(CD))]
    public class BedUnavailableHistory : BedUnavailable
    {
        #region Public Members
        /// <summary>
        /// Gets or sets the COMMENT.
        /// </summary>
        /// <value>
        /// The COMMENT.
        /// </value>
        [XmlElementAttribute("Comment", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 1)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is change only comment.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is change only comment; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsChangeOnlyComment", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "IsChangeOnlyComment", Order = 2)]
        public bool IsChangeOnlyComment { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is clear all.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is clear all (reason and comment); otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsClearAll", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "IsClearAll", Order = 3)]
        public bool IsClearAll { get; set; }

        /// <summary>
        /// Gets or sets the ward list.
        /// </summary>
        /// <value>
        /// The ward list.
        /// </value>
        [XmlElementAttribute("DivisionList", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "DivisionList", Order = 4)]
        public List<II> DivisionList { get; set; }

        #endregion
    }
}
