﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.MT;
using BMS.Translators;

namespace BMS.Translators
{
    /// <summary>
    /// Translator class for standart patient waiting entity
    /// </summary>
    public static class TranslatorStandardPatientWaiting
    {

        public static void CopyTo(this PatientWaitingStandardViewBO patientWaitingBO, DataContracts.PatientWaitingStandardView patientWaiting)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                patientWaiting.CanceledDate = patientWaitingBO.CANCELED_DATE.Value;
                patientWaiting.CreationDate = patientWaitingBO.CREATION_DATE.Value;
                patientWaiting.Id = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.ACT_ID);
                patientWaiting.Parent = TranslatorUtils.BuildParentAct(TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.PARENT_ACT_ID));
                patientWaiting.PatientId = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.PATIENT_UID);
                patientWaiting.FlowId = patientWaitingBO.FLOW_ID.Value;
                patientWaiting.Era = TranslatorUtils.BuildConcept(patientWaitingBO.REQ_ERA_CODE, patientWaitingBO.REQ_ERA_CODE_SYSTEM, patientWaitingBO.REQ_ERA_CODE_SYSTEM_NAME, patientWaitingBO.REQ_ERA_DISPLAY_NAME);
                patientWaiting.AdmissionFacilityId = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.EVN_ADMISSION_FACILITY_UID);
                patientWaiting.FacilityId = TranslatorUtils.BuildIdentifier(patientWaitingBO.DOMAIN_ID, patientWaitingBO.REQ_FACILITY_UID);
                patientWaiting.Contract = TranslatorUtils.BuildConcept(patientWaitingBO.REQ_CONTRACT_CODE, patientWaitingBO.REQ_CONTRACT_CODE_SYSTEM, patientWaitingBO.REQ_CONTRACT_CODE_SYSTEM_NAME, patientWaitingBO.REQ_CONTRACT_DISPLAY_NAME);
                patientWaiting.Diagnosis = patientWaitingBO.REQ_DIAGNOSIS.Value;
                patientWaiting.CurrentLocation = patientWaitingBO.REQ_CURRENT_LOCATION.Value;
                patientWaiting.Speciality = TranslatorUtils.BuildConcept(patientWaitingBO.REQ_SPECIALITY_CODE, patientWaitingBO.REQ_SPECIALITY_CODE_SYSTEM, patientWaitingBO.REQ_SPECIALITY_CODE_SYSTEM_NAME, patientWaitingBO.REQ_SPECIALITY_DISPLAY_NAME);
                patientWaiting.Comment = patientWaitingBO.REQ_COMMENTS.Value;
                patientWaiting.DispositionDate = patientWaitingBO.EVN_DISPOSITION_DATE.Value;
                patientWaiting.EventDate = patientWaitingBO.EVN_EVENT_DATE.Value;
                patientWaiting.RegionCode = patientWaitingBO.REGION_CODE.Value;
                patientWaiting.VISNCode = patientWaitingBO.VISN_CODE.Value;
                patientWaiting.IsNationalWaitList = patientWaitingBO.IS_NATIONAL_WAIT_LIST.Value == true ? true : false;
                //HHG: Adding ReqCreateDateTime and EvnCreateDateTime
                patientWaiting.ReqCreateDateTime = patientWaitingBO.REQ_CREATED.Value;
                patientWaiting.EvnCreateDateTime = patientWaitingBO.EVN_CREATED.Value;

                
                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
