﻿using BMS.MT;
using System;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorEmsStaff
    {
        public static void CopyTo(this EmsStaffBO emsStaffBO, DataContracts.EmsStaff emsStaff, string domainId)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                emsStaff.Id = TranslatorUtils.BuildIdentifier(domainId, emsStaffBO.ID.Value.ToString());
                emsStaff.Pin = emsStaffBO.PIN.Value;
                emsStaff.UserName = emsStaffBO.USER_NAME.Value;
                emsStaff.FacilityId = TranslatorUtils.BuildIdentifier(domainId, (emsStaffBO.FACILITY_UID.Value.HasValue) ? emsStaffBO.FACILITY_UID.Value.Value.ToString() : null);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.EmsStaff emsStaff, EmsStaffBO emsStaffBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                emsStaffBO.ID.Value = (emsStaff.Id != null && !string.IsNullOrEmpty(emsStaff.Id.extension) && int.Parse(emsStaff.Id.extension) > 0) ? int.Parse(emsStaff.Id.extension) : (int?)null;
                emsStaffBO.PIN.Value = emsStaff.Pin;
                emsStaffBO.USER_NAME.Value = emsStaff.UserName;                                
                if (emsStaff.FacilityId != null)
                    emsStaffBO.FACILITY_UID.Value = Guid.Parse(emsStaff.FacilityId.extension);                
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
