﻿using BMS.MT;
using System;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorDiversion
    {
        public static void CopyTo(this DiversionBO diversionBO, DataContracts.Diversion diversion)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                diversion.Active = diversionBO.ACTIVE.Value;
                diversion.Comments = diversionBO.COMMENTS.Value;
                diversion.WardGroup = diversionBO.WARD_GROUP.Value;
                diversion.TreatingSpecialty = diversionBO.TREATING_SPECIALTY.Value;
                diversion.StartDate = diversionBO.START_DATE.Value;
                diversion.EndDate = diversionBO.END_DATE.Value;
                diversion.FacilityId = TranslatorUtils.BuildIdentifier(diversionBO.DOMAIN_ID, diversionBO.FACILITY_UID);
                diversion.Id = TranslatorUtils.BuildIdentifier(diversionBO.DOMAIN_ID, diversionBO.DIVERSION_ID);
                diversion.Location = TranslatorUtils.BuildConcept(diversionBO.LOCATION_CODE, diversionBO.LOCATION_CODE_SYSTEM, diversionBO.LOCATION_CODE_SYSTEM_NAME, diversionBO.LOCATION_DISPLAY_NAME);
                diversion.EnteredBy = diversionBO.ENTERED_BY.Value;
                diversion.EnteredDate = diversionBO.ENTERED_DATE.Value;
                diversion.LastEditBy = diversionBO.LAST_EDIT_BY.Value;
                diversion.VistaSiteId = TranslatorUtils.BuildIdentifier(diversionBO.DOMAIN_ID, diversionBO.VISTA_SITE_UID);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.Diversion diversion, DiversionBO diversionBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                diversionBO.ACTIVE.Value = diversion.Active;
                diversionBO.COMMENTS.Value = diversion.Comments;
                diversionBO.WARD_GROUP.Value = diversion.WardGroup;
                diversionBO.TREATING_SPECIALTY.Value = diversion.TreatingSpecialty;
                diversionBO.WARD_GROUP.Value = diversion.WardGroup;
                diversionBO.TREATING_SPECIALTY.Value = diversion.TreatingSpecialty;
                diversionBO.START_DATE.Value = diversion.StartDate;
                diversionBO.END_DATE.Value = diversion.EndDate;
                diversionBO.ENTERED_BY.Value = diversion.EnteredBy;
                diversionBO.ENTERED_DATE.Value = diversion.EnteredDate;
                diversionBO.LAST_EDIT_BY.Value = diversion.LastEditBy;

                if (diversion.FacilityId != null)
                    diversionBO.FACILITY_UID.Value = System.Guid.Parse(diversion.FacilityId.extension);                    
                if (diversion.Location != null)
                {
                    diversionBO.LOCATION_CODE.Value = diversion.Location.code;
                    diversionBO.LOCATION_CODE_SYSTEM.Value = diversion.Location.codeSystem;
                    diversionBO.LOCATION_CODE_SYSTEM_NAME.Value = diversion.Location.codeSystemName;
                    diversionBO.LOCATION_DISPLAY_NAME.Value = diversion.Location.displayName;
                }
                if (diversion.Id != null)
                {
                    int? diversionId = diversion.Id.extension.ParseAsInt();
                    if (diversionId.HasValue)
                        diversionBO.DIVERSION_ID.Value = diversionId.Value;
                    diversionBO.DOMAIN_ID.Value = diversion.Id.root;
                }
                if (diversion.VistaSiteId != null)
                    diversionBO.VISTA_SITE_UID.Value = System.Guid.Parse(diversion.VistaSiteId.extension);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
