﻿using BMS.MT;
using System;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorBedSwitch
    {
        public static void CopyTo(this DataContracts.BedSwitch bedSwitch, BedSwitchBO bedSwitchBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (bedSwitch.BedId != null)
                    bedSwitchBO.BED_UID.Value = Guid.Parse(bedSwitch.BedId.extension);
                else
                    bedSwitchBO.BED_UID.Value = null;
                bedSwitchBO.ENTERED_DATE.Value = bedSwitch.EnteredDate;                
                if (bedSwitch.Id != null)
                {
                    bedSwitchBO.DOMAIN_ID.Value = bedSwitch.Id.root;
                    int? id = bedSwitch.Id.extension.ParseAsInt();
                    if (id.HasValue)
                        bedSwitchBO.ID.Value = id.Value;
                }
                bedSwitchBO.IEN.Value = bedSwitch.Ien;
                if (bedSwitch.OldBedId != null)
                    bedSwitchBO.OLD_BED_UID.Value = Guid.Parse(bedSwitch.OldBedId.extension);
                else
                    bedSwitchBO.OLD_BED_UID.Value = null;
                if (bedSwitch.PatientId != null)
                    bedSwitchBO.PATIENT_UID.Value = System.Guid.Parse(bedSwitch.PatientId.extension);
                if (bedSwitch.VistaSiteId != null)
                    bedSwitchBO.VISTA_SITE_UID.Value = Guid.Parse(bedSwitch.VistaSiteId.extension);
                if (bedSwitch.WardId != null)
                    bedSwitchBO.WARD_UID.Value = Guid.Parse(bedSwitch.WardId.extension);
                else
                    bedSwitchBO.WARD_UID.Value = null;
                bedSwitchBO.ADMISSION_IEN.Value = bedSwitch.AdmissionIen;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
